#include "mbed.h"
#ifndef EPOSS
#define EPOSS

/* -----------------------------------------------------------------------------
EPOS commands that you need to home, you can find those in chapter 8.3 from the 
application node. 
----------------------------------------------------------------------------- */
const char Shutdown_Data[8] = {0x2B,0x40,0x60,0x00,0x06,0x00,0x00,0x00};        //voorkomen dat je niet nog in een andere mode zit
    
const char Switch_On_And_Enable_Data[8] = {0x2B,0x40,0x60,0x00,0x0F,0x00,0x00,0x00}; //enable de motorcontroller (groene ledje constant aan)

const char Homing_Mode_Data[8] = {0x2F,0x60,0x60,0x00,0x06,0x00,0x00,0x00};     //aan de 0x6060-00 geef je aan dat je nu gaat homen wat de waarde 06 heeft in de data bytes
    
const char Homing_Method_Data_Positive[8] = {0x2F,0x98,0x60,0x00,0xFD,0x00,0x00,0x00};  //bij de index 0x6098-00 geef je aan welke homing method je gaat gebruiken: 0xFD = -3 = current treshold positive speed

const char Homing_Method_Data_Negative[8] = {0x2F,0x98,0x60,0x00,0xFC,0x00,0x00,0x00};  //bij de index 0x6098-00 geef je aan welke homing method je gaat gebruiken: 0xFC = -4 = current treshold negative speed
    
const char Start_Homing_Data[8] = {0x2B,0x40,0x60,0x00,0x1F,0x00,0x00,0x00}; //om te beginnen met homen geef je het controlword de waarde 0x001F om het homen te starten 

const char Status_Word_Data[4] = {0x40,0x41,0x60,0x00};  //0x40, want ccs is 2: je upload iets van de controller om te kijken of het gelukt is. 

const char Clear_Fault_Data[8] = {0x2B,0x40,0x60,0x00,0x80,0x00,0x00,0x00}; //Clear fault: 0x0080 versturen naar 0x6040-00    

/* -----------------------------------------------------------------------------
Additional EPOS commands that you need for going to a position, you can find 
those in chapter 8.7 from the application node. 
----------------------------------------------------------------------------- */
const char Position_Mode_Data[8] = {0x2F,0x60,0x60,0x00,0xFF,0x00,0x00,0x00};

/* -----------------------------------------------------------------------------
Sends a CAN Message to the controller
Returns 1 for succes. May be slow. a faster send message is build into Goto_Pos
@param COB_ID
@param Message length
@param Data string
----------------------------------------------------------------------------- */
CANMessage create_CAN_msg(int COB_ID, int LENGTH, char * DATA);
    
//A struct in which msg_1 is saved
//struct EPOS_MESSAGES {
//    CANMessage msg_1;
//};

//CANMessage Latest_EPOS_msg(int NODE_ID);   
 
// The EPOS class
class EPOS{
    
    public:
    
    int NODE_ID;   // the CAN adress of this controller
    
    EPOS(int node_id){
        NODE_ID=node_id;
        };

    /** puts the EPOS in shutdown state */
    CANMessage Shutdown();
    
    /** puts the EPOS in Switchon state */
    CANMessage SwitchOnAndEnable();
     
    /** Requests a statusword from the EPOS */
    CANMessage StatusWord();
    
    /** puts the EPOS in homing mode */
    CANMessage HomingMode();
    
    /** sets the homing method to current mode positive speed */
    CANMessage HomingMethodPositive();
    
    /** sets the homing method to current mode positive speed */
    CANMessage HomingMethodNegative();
    
    /** puts the EPOS in start homing state */
    CANMessage StartHoming();
     
    /** Resets the fault condition on the EPOS */
    CANMessage ClearFault();
    
    /** Function that defines a message with the right amount of quartercircles */
    CANMessage GoToPosition(int quartercircles);
    
    /** Function that defines a message with the right amount of quartercircles */
    CANMessage PositionMode();

    /** Homes the EPOS with Current mode */
    void Homing();
    
    /** With this function the axis moves to the new absolute position */
    void StartPositionMode();
};

#endif