/* 
 * File:   pid.h
 * Author: User
 *
 * Created on 27 februari 2019, 10:28
 */

#ifndef _PID_H_
#define _PID_H_
#include "DataStore.h"
namespace control{

class PIDImpl
{
    public:
        PIDImpl( double dt, double Kp, double Kd, double Ki, double Fc );
        ~PIDImpl();
        double calculate( double setpoint, double pv );
    private:
        double _dt;
        double _max;
        double _min;
        double _Kp;
        double _Kd;
        double _Ki;
        double _Fc;
        double _pre_error;
        double _integral;
};

class PID
{
    public:
        // Kp -  proportional gain
        // Ki -  Integral gain
        // Kd -  derivative gain
        // dt -  loop interval time
        // max - maximum value of manipulated variable
        // min - minimum value of manipulated variable
        PID( double dt, double Kp, double Kd, double Ki, double Fc);

        // Returns the manipulated variable given a setpoint and current process value
        double calculate( double setpoint, double pv );
        ~PID();

    private:
        PIDImpl *pimpl;
};
}
#endif

