#ifndef _MBED_HTTP_PARSED_URL_H_
#define _MBED_HTTP_PARSED_URL_H_

#include "http_parser.h"

class ParsedUrl {
public:
    ParsedUrl(const char* url) {
        struct http_parser_url parsed_url;
        http_parser_parse_url(url, strlen(url), false, &parsed_url);

        for (size_t ix = 0; ix < UF_MAX; ix++) {
            const char* value;
            if (parsed_url.field_set & (1 << ix)) {
                value = (const char*)calloc(parsed_url.field_data[ix].len + 1, 1);
                memcpy((void*)value, url + parsed_url.field_data[ix].off,
                       parsed_url.field_data[ix].len);
            }
            else {
                value = (const char*)calloc(1, 1);
            }

            switch ((http_parser_url_fields)ix) {
                case UF_SCHEMA:   _schema   = value; break;
                case UF_HOST:     _host     = value; break;
                case UF_PATH:     _path     = value; break;
                case UF_QUERY:    _query    = value; break;
                case UF_USERINFO: _userinfo = value; break;
                default:
                    // PORT is already parsed, FRAGMENT is not relevant for HTTP requests
                    free((void*)value);
                    break;
            }
        }

        _port = parsed_url.port;
        if (!_port) {
            if (strcmp(_schema, "https") == 0) {
                _port = 443;
            }
            else {
                _port = 80;
            }
        }
    }

    ~ParsedUrl() {
        if (_schema) free((void*)_schema);
        if (_host) free((void*)_host);
        if (_path) free((void*)_path);
        if (_query) free((void*)_query);
        if (_userinfo) free((void*)_userinfo);
    }

    uint16_t port() const { return _port; }
    const char* schema() const { return _schema; }
    const char* host() const { return _host; }
    const char* path() const { return _path; }
    const char* query() const { return _query; }
    const char* userinfo() const { return _userinfo; }

private:
    uint16_t _port;
    const char* _schema;
    const char* _host;
    const char* _path;
    const char* _query;
    const char* _userinfo;
};

#endif // _MBED_HTTP_PARSED_URL_H_
