#include "mbed.h"
#include "DS1820.h"

#define MAX_PROBES      16

DS1820* probe[MAX_PROBES];

int main() {
    // Initialize the probe array to DS1820 objects
    probe[0] = new DS1820(GPIO4);
    probe[1] = new DS1820(GPIO5);
    probe[2] = new DS1820(GPIO6);
    probe[3] = new DS1820(GPIO7);

    while(1) {
        probe[0]->convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        probe[1]->convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        probe[2]->convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        probe[3]->convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready

        printf("Device %d returns %3.1foC\r\n", 0, probe[0]->temperature());
        printf("Device %d returns %3.1foC\r\n", 1, probe[1]->temperature());
        printf("Device %d returns %3.1foC\r\n", 2, probe[2]->temperature());
        printf("Device %d returns %3.1foC\r\n", 3, probe[3]->temperature());
        printf("\r\n");
        wait(1);
    }
}