#include "mbed.h"
#include "scolor_TCS3200.h"
 
Serial command(USBTX, USBRX);
PwmOut mybuzzer(D9);
//                     S0,    S1,   S2,   S3,    OUT
scolor_TCS3200 scolor(PA_8, PB_10, PB_4, PB_5, PB_3); 
 
#define INITCMD 0xFE
#define INITELE 0xFE
#define CMD  0x01
#define DO  100
#define RE  150 
#define MI  200
#define FA  250
#define SO  300 
 
uint8_t tono;       // variable almacena la frecuencia del buzzer
uint8_t tiempo;    // varable almacena los tiempos del buzzer leer_datos()
uint8_t cmd;
 
// definición de las funciones
void setup_uart();
void buzzer_on(uint8_t tono);
void leer_datos();
void leer_color();
 
    
    
int main() {
 
    setup_uart();
    
    while(1){    
        leer_datos();
        if (cmd==CMD){
            leer_color();
           }    
           }
}
 
void setup_uart(){
    command.baud(115200);
}
 
 
void leer_datos(){
     cmd=command.getc();     
}
 
 
void leer_color(){
        
    long     red = scolor.ReadRed();
    long     green = scolor.ReadGreen();
    long     blue = scolor.ReadBlue();
    long     clear = scolor.ReadClear();
    long freqrojo;
    long freqverde;
    long freqazul;
    mybuzzer.write(0);
        freqrojo=((1.0/(2*red))*1000);
          freqverde=((1.0/(2*green))*1000);
            freqazul=((1.0/(2*blue))*1000);
  
    if ( freqrojo>=0 and  freqrojo <=7) // lee  rojo
        {
            if (freqverde>=1200 and freqverde<=1500)
            {
                if ( freqazul>=1200 and  freqazul <=1500)
                {
            
            printf("|FE 01|\n");
            mybuzzer.period_ms(DO);
            mybuzzer.write(0.5);
            wait_ms(4000);
            mybuzzer.write(0);
                                 
                            }
            }
        }
        
         if ( freqrojo <=2700)  // lee  verde 
        {
            if (freqverde>=900 and freqverde <=1500)
            {
                if ( freqazul>=1400 and  freqazul <=2000)
                {
            
            printf("|FE 03|\n"); 
            mybuzzer.period_ms(RE);
            mybuzzer.write(0.5);
            wait_ms(4000);
            mybuzzer.write(0);      
                          
                }
            }
        }
        
         if ( freqrojo<=2400) // lee azul
        {
            if (freqverde>=800 and freqverde <=1000)
            {
                if ( freqazul>=600 and  freqazul <=800)
                {
                        
            printf("|FE 02|\n");
            mybuzzer.period_ms(MI);
            mybuzzer.write(0.5);
            wait_ms(4000);
            mybuzzer.write(0);
                        
                }
            }
        }
       if ( freqrojo <=700) // lee  amarillo
        {
            if (freqverde>=500 and freqverde <=700)
            {
                if ( freqazul>=500 and  freqazul<=1500)
                {
                        
            printf("|FE 04|\n");
            mybuzzer.period_ms(FA);
            mybuzzer.write(0.5);
            wait_ms(4000);
            mybuzzer.write(0);
                     
                }
            }
        }
        
        if ( freqrojo <=200) //No lee nada
        {
            if (freqverde <=300)
            {
                if ( freqazul <=300)
                {
                        
            printf("|FE 00|\n");
            mybuzzer.period_ms(SO);
            mybuzzer.write(0.5);
            wait_ms(4000);
            mybuzzer.write(0);
                     
                }
            }
        }
     
  //   printf("RED: %5d     GREEN: %5d     BLUE: %5d     CLEAR: %5d     \n ", red, green, blue, clear);
     }