#include "mbed.h"
#include "scolor_TCS3200.h"
#include "colorsensor.h"

/* *****************************************************************************
Programa que solicita telemetria al sistema embebido, por medio del comando  0xFe
para preguntar por el color  que detecta el sensor TCS3200

el sistema embebido recibe  el inicio de trama FE  y el número de comado: 01
   
|   INITELE  |  CMD       |   
|     0xfe   | 0x01       | 


para enviar los comandos usar el programa Coolterm http://freeware.the-meiers.org/


@fabeltranm 2019
fbeltranm@ecci.edu.co

********************************************************************************
   datasheet https://www.mouser.com/catalog/specsheets/TCS3200-E11.pdf


    S0      Frequency scaling 
    S1      Frequency scaling 
    S2      Photo diode selection 
    S3      Photo diode selection 
    OutFreq Frequency

       -----------------------------------
      |   ____________     ____________   |
----> |  |            |   |            |  |                ___     ___ 
Light |  | Photodiode |   |   Current  |--|---OUTPUT_FREQ |   |___|   |___
----> |  |   Array    |---|     to     |  |
      |  |            |   |  Frequency |  |
      |  |____________|   |____________|  |
      |       ^  ^             ^  ^       |
       -------|--|-------------|--|-------
              |  |             |  |
             S2 S3            S0  S1
             
SO | S1 | OUTPUT FREQUENCY SCALING |        | S2 | S3 |   PHOTODIODE TYPE   |
 0 | 0  |        power down        |        |  0 | 0  |         Red         |
 0 | 1  |           2%             |        |  0 | 1  |         Blue        |
 1 | 0  |           20%            |        |  1 | 0  |  Clear (no filter)  |
 1 | 1  |           100%           |        |  1 | 1  |         Green       | 
             
******************************************************************************/
#define INITCMD 0xFF // comando de sonido ff 01 3
#define INITELE 0xFE // comando de sensor de colores fe 01
#define CMD  0x01 // 

#define DO  104 
#define RE  153
#define MI  166
#define FA  184
#define SO  205



Serial command(USBTX, USBRX);
//                              S0, S1, S2, S3, OUT
Serial serial(USBTX, USBRX);
iotea::ColorSensor color_sensor(D6, D5, D4, D3, D2);
DigitalIn button(D12);

// definición de las funciones

int main() {
    serial.baud(115200);
    while (true) {
        if (!button) {
            iotea::ColorData color = color_sensor.getData();
            serial.printf("#%d %d %d\r\n", color.red, color.green, color.blue);
        }
    }
}

