#pragma color

#include <cstdint>
#include <cstddef>
#include "mbed.h"
#include "color.h"

namespace icolor {

    using ColorRGB = Color<uint8_t>;
    using ColorData = Color<int32_t>;

    class ColorSensor {
    public:
        enum class Frequency {
            DOWN = 0,
            SCALE_2 = 1,
            SCALE_20 = 2,
            SCALE_100 = 3
        };

        enum class Filter {
            RED = 0,
            BLUE = 1,
            CLEAR = 2,
            GREEN = 3
        };

        ColorSensor(
                PinName s0, PinName s1, PinName s2, PinName s3, PinName out) noexcept;

        /**
         * Se establece la frecuencia.
         * Por defecto la frecuencia::SCALE_100
         **/
        void setFrequency(Frequency frequency) noexcept;

        /**
         * Establece los pines del filtro fotodiodo..
         **/
        void setFilter(Filter filter) noexcept;

        /**
         * Establece los datos de calibración para el color negro.
         **/
        void calibrateBlack(ColorData colorData) noexcept;

        /**
         * Establece los datos de calibración para el color blanco.
         **/
        void calibrateWhite(ColorData colorData) noexcept;

        /**
         * Lee el  sensor de datos en la fprma estandar del RGB.
         * @Regresa RGB color.
         **/
        ColorRGB getRGB() const noexcept;

        /**
         * Leer datos del sensor en forma BASICA.
         * @Regresa los datos del  color basico.
         **/
        ColorData getData() const noexcept;

    protected:
        /// Pines utilizados para escalador de frecuencia
        DigitalOut s0, s1;
        /// Pines utilizados para el filtro fotodiodo.
        DigitalOut s2, s3;
        /// Output pin
        InterruptIn out;
        /// Datos sin procesar del sensor en lectura actual
        ColorData colorData{0, 0, 0};
        /// Datos de calibracion del sensor
        ColorData calibrationBlack{6000L, 6000L, 6000L};
        ColorData calibrationWhite{55000L, 55000L, 55000L};

    private:
        /**
         * Lee el valor del contador y lo guarda en el estado actual.
         **/
        void readCounter() noexcept;

        /// Estado actual del contador
        size_t state;
        Ticker ticker;
        int32_t counter;

        void convertRGB(ColorRGB *colorRGB) const noexcept;
    };

}