#include "mbed.h"
#include "TextLCD.h"
#include "TSISensor.h"

TextLCD lcd(PTD1,PTD3,PTD2,PTD0,PTD5,PTA13); // rs, e, d4-d7
// number of seconds to wait between each frame movement
float frameTime = 1;
// number of frames since speed increase
int steps = 0;
// number of frames in total
int score = 0;
// size of course
int courseSize = 48;

int main() 
{
    // set up course
    char course[courseSize][2];
    
    // blank course to start with
    for(int i = 0; i < courseSize; i++) {
        course[i][0] = ' ';
        course[i][1] = ' ';
    }
    
    // obstacles
    course[3][0] = '0';
    course[6][1] = '0';
    course[9][1] = '0';
    course[12][0] = '0';
    course[15][1] = '0';
    course[16][1] = '0';
    course[19][0] = '0';
    course[21][1] = '0';
    course[23][0] = '0';
    course[24][0] = '0';
    course[29][1] = '0';
    course[33][0] = '0';
    course[35][0] = '0';
    course[37][0] = '0';
    course[40][1] = '0';
    course[43][0] = '0';
    course[46][1] = '0';
    
    // set up LED output
    PwmOut led(LED_GREEN);
    // set up touch sensor to control game
    TSISensor tsi;
    
    int gameover = 0;
    
    // game loop
    while(1) {    
        
        // print current course on lcd
        for(int i = 15; i >= 0; i--) {
            lcd.locate(i,0);
            lcd.printf("%c",course[i][0]);
            lcd.locate(i,1);
            lcd.printf("%c",course[i][1]);
        }       
        
        
        // create next frame of course
        // course loops round infinitely
        
        // these are rows that will be pushed off top of screen
        // save them so they can be put at bottom once finished
        char toprow1 =  course[courseSize-1][0];
        char toprow2 =  course[courseSize-1][1];
        
        // shift each row up 1
        for(int i = courseSize-1; i >= 0; i--) {
        
            course[i][0] = course[i-1][0];
            course[i][1] = course[i-1][1];
        
        }
        
        // set bottom rows as the top rows that have been pushed off
        course[0][0] = toprow1;
        course[0][1] = toprow2;
        
        // game control
        // what to do if controller is on right
        
        if (tsi.readPercentage() >= 0.5) { // if on one side of touchpad
            // go to column
            lcd.locate(15,1);
            // print game character
            lcd.printf("%c",'<');
            
            // check whether there is collision
            if(course[15][1] == '0')
            {
                // clear screen
                lcd.cls();
                // let user know game is over
                lcd.printf("Game Over!!\n Score %d", score);
                gameover = 1;
            }          
        }   
    
        // when controller is on left
        else {
            // go to column
            lcd.locate(15,0);
            // print game character
            lcd.printf("%c",'<');
            
            // check whether there is collision
            if(course[15][0] == '0')
            {
                // clear screen
                lcd.cls();
                // let user know game is over
                lcd.printf("Game Over!!\n Score %d", score);
                gameover = 1;
            }
        }
    
    // delay between each frame    
    wait(frameTime);
    // add to steps 
    steps++;     
    // add to score
    score++;
    // check whether enough steps completed to speed game up
    if(steps > 5) {   
        frameTime -= 0.05;
        // reset number of steps
        steps = 0;
    }
    
    if(gameover == 1)
    {
    wait(10);
    gameover = 0;
    score = 0;
    frameTime = 1;
    }
  }
    
}
