#include "throttle.h"

AnalogIn gripThrottle(p17);
AnalogOut throttleOut(p18); 
DigitalIn gripButton(p6);

Throttle* Throttle::instance = NULL;

Throttle *Throttle::getThrottle(float *I, float *v_f, float *v_r, float *cadence, AnalogIn* break_l, AnalogIn *break_r) {
    if (instance == NULL) {
        instance = new Throttle(I, v_f, v_r, cadence, break_l, break_r);
    }
    return instance;
}

Throttle::Throttle(float *I, float *v_f, float *v_r, float *cadence, AnalogIn* break_l, AnalogIn *break_r) :
                   mode(off), state(waiting),
                   I(I), v_f(v_f), v_r(v_r), cadence(cadence),
                   brkl(break_l), brkr(break_r),
                   target(0.0f), iLimit(0.0f), speedLimit(0.0f),
                   enforceSpeedLimit(false)
                   {
    throttleOut = 0.0f;
    gripButton.mode(PullUp);
    tick.attach(this, &Throttle::onTick, 0.001);
}

Throttle::~Throttle() {
    tick.detach();
    throttleOut = 0.0f;
}

void Throttle::onTick() {
    if (brkl->read() < break_inhibit_threshold && brkr->read() < break_inhibit_threshold) {
        switch(mode) {
        case off:
            throttleOut = 0.0f;
            break;
        case raw:
            throttleOut = gripThrottle;
            break;
        case cruise_raw:
            throttleOut = target;
            break;
        default:
            throttleOut = 0.0f;
        }
    }
    else {
        state = inhibited;
    }
}

void Throttle::setMode(ThrottleMode m) { mode = m; }

void Throttle::setILimit(float I) { iLimit = I; }

void Throttle::setSpeedLimit(float v, bool enforce) {
    speedLimit = v;
    enforceSpeedLimit = enforce;
}

