#include "mbed.h"
#include "AndroidAccessory.h"
#include "throttle.h"

DigitalOut l_running(LED1);
DigitalOut l_cruise(LED2);
DigitalOut l_error(LED3);
DigitalOut l_debug(LED4);

AnalogIn break_l(p19);
AnalogIn break_r(p20);

static const size_t OUTL=61;
static const size_t INBL=61;

class DroidCycleMbed : public AndroidAccessory {
public:
    DroidCycleMbed();
    
    virtual void setupDevice();
    virtual void resetDevice();
    virtual int callbackRead(u8 *buff, int len);
    virtual int callbackWrite();
    
private:
    void onTick();
    void throttleTick();
    char buffer[OUTL];
    int bcount;
    unsigned int blink_counter;
    Ticker tick;
    Timeout n;
    Throttle* thr;
    float I, v_f, v_r, cadence;
};

DroidCycleMbed::DroidCycleMbed() : AndroidAccessory(INBL, OUTL,
                                                    "DC Labs",
                                                    "DroidCycle",
                                                    "Android E-Bike controller interface",
                                                    "0.1",
                                                    "http://www.danielcasner.org",
                                                    "0000000123456789"),
                                                    bcount(0),
                                                    blink_counter(0),
                                                    thr(NULL) {
    thr = Throttle::getThrottle(&I, &v_f, &v_r, &cadence, &break_l, &break_r);
    tick.attach(this, &DroidCycleMbed::onTick, 0.010);
}

void DroidCycleMbed::setupDevice() {
    for (int i=0; i<OUTL; i++) buffer[i] = 0;
    bcount = 0;
}

void DroidCycleMbed::resetDevice() {
    setupDevice();
}

int DroidCycleMbed::callbackRead(u8 *buf, int len) {
    for (int i=0; i<INBL; i++) buf[i] = 0;
    
    return 0;
}

int DroidCycleMbed::callbackWrite() {
    return false;
}


void DroidCycleMbed::onTick() {
    blink_counter++;
    if (blink_counter < 10) l_running = 1;
    else if (blink_counter < 200) l_running = 0;
    else blink_counter = 0;
}

int main() {
    DroidCycleMbed instance;
    
    USBInit();
    while (1) {
        USBLoop();
    }
}
