
#include "mbed.h"
#include "MAX31855.h"
#include "SDSaveFunction.h"

Serial pc(USBTX,USBRX);
SPI spi(NC,PTD3,PTD1);
SPI sdspi(PTE3,PTE1,PTE2);
DigitalIn eject(PTA4); // INT2
DigitalOut greenLed(LED2); 
DigitalOut redLed(LED1);

MAX31855 thermometer1(spi,PTB9);
MAX31855 thermometer2(spi,PTD0);
AnalogIn solarPanel(PTB2);
Timer t;


int main()
{
    const int secondsHalfHour = 30*60; //number of seconds in 1 half hour
    redLed = 0;
    greenLed = 1;
    wait(0.5);
    redLed = 1;
    greenLed = 0;
    wait(0.5);
    greenLed = 1;
    float temp1, temp2;
    float lastTime = 0;
    float dt = 0.5;
    float voltage = 0;
    float halfHour = 0;
    float totalTime;
    t.start();
    mountSDCard();
    openDataFile();
    while (halfHour<6) {
        if (eject == 0) {
            greenLed = 0;
            wait(0.5);
            greenLed = 1;
            break;
        }
        totalTime = secondsHalfHour*halfHour + t.read();
        if (totalTime>lastTime+dt) {
            lastTime = totalTime;
            temp1 = thermometer1.read();
            wait(.02);
            temp2 = thermometer2.read();
            voltage = 3.3*(solarPanel.read()); 
            pc.printf("Voltage %f\t Temp1 %f\t Temp2 %f\t Time %f\r\n", voltage, temp1, temp2, lastTime);
            writeData(lastTime, temp1, temp2, voltage);
        }
        if (t.read()>=secondsHalfHour){
            halfHour++;
            t.reset();
        }
    }
    closeDataFile();
    greenLed = 0;
    while(true){
        
        }
}