/* Program demonstrating data logging to SD card Analog data is read in (from a potentiometer). The time since program start and the voltage are written to a tab-delimited data file.
*/
#include "mbed.h"
#include "SDFileSystem.h"
#include "SDSaveFunction.h"

//Create an SDFileSystem object

SDFileSystem fs(PTE3, PTE1, PTE2, PTE4, "fs");
FILE *fp;

extern Serial pc;

int mountSDCard() {
    //Mount the filesystem
    int mountFailure = fs.mount();
    if (mountFailure != 0) {
        pc.printf("Failed to mount the SD card.\n\r");
        return -1; // ends function with error status
    }
    else
        return 0;
}

int openDataFile() {
    fp = fopen("/fs/dataLog.txt", "w"); // Open file and prepare to write
    if (fp == NULL) {
        pc.printf("Failed to open file.\n\r");
        return -1;
    }
    // Write a header row
    fprintf(fp, "Time (s) \t Temp1 (C) \t Temp2 (C) \t Voltage (V)\n\r"); // Needs to be modified for your particular experiment
    return 0;
}

int closeDataFile() {  // Close the file and unmount the file system so the SD card is happy
    fclose(fp);
    fs.unmount();
    pc.printf("It is now safe to remove the memory card.\r\n");
    
    return 0;
}

void writeData(float time, float temp1, float temp2, float voltage) {  
    fprintf(fp, "%.2f \t %.2f \t %.2f \t %.2f \n\r", time , temp1 , temp2 , voltage);
}
