#include "mbed.h"
#include "USBKeyboard.h"
#include "rtos.h"
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalIn button(p14);

USBKeyboard keyboard;

void launch_site() {
  keyboard.keyCode(' ', 8);
  led1 = 1;
  wait_ms(750);
  keyboard.printf("terminal");
  wait_ms(50);
  keyboard.printf("\n");
  led2 = 1;
  wait_ms(750);
  keyboard.keyCode('n', 8);
  led3 = 1;
  wait_ms(750);
  keyboard.printf("open http://dan.f-box.org/tmp/3/\n");
  led4 = 1;
}

void button_thread(void const *args) {
    while (true) {
      if (button) {
        launch_site();
      }
      Thread::wait(500);
    }
}
int main(void) {
    Thread thread(button_thread);
    while (1) {
      Thread::wait(500000);
    }
}