/*********************************************************
*TimedMovement.h                                         *
*Author: Elijah Orr                                      *
*                                                        *  
*A library of functions that can be used to control the  * 
*RenBuggy.                                               *
*********************************************************/

/* include guards are used to prevent problems caused by 
multiple definitions */
#ifndef TIMEDMOVEMENT_H
#define TIMEDMOVEMENT_H

/* mbed.h must be included in this file also */
#include "mbed.h"

/* #define LeftMotorPin p5 tells the preprocessor to replace
any mention of LeftMotorPin with p5. This is used to select 
which pins to use to control the motors. Here pins 5 and 6 
are used. */
#define LeftMotorPin p5
#define RightMotorPin p6

/* these are function prototypes that declare all the functions
in the library. extern tells the compiler that the functions
may be called in other files, such as main.cpp. void specifies 
that the function will not return a value, i.e. the program will 
execute the function and then move on the the next line of code. 
forward is the name of the function and float specifies that 
the function expects to be passed a variable of the format float. */
extern void forward(float);
extern void left(float);
extern void right(float);
extern void hold(float);
extern void stop();

extern void readButton(float);
extern int rollDice();
/* stop() is slightly different in that it doesn't expect to be passed
any variables, so the parentheses can be left empty. Passing a variable
to this function would cause an error */

#endif // TIMEDMOVEMENT_H