/*********************************************************
*RenBuggyTimed                                           *
*Author: Dan Argust                                      *
*                                                        *  
*This program demonstates use of a library of functions  *
*(TimedMovement) to control the movement of the RenBuggy.*
*                                                        *
*********************************************************/

/* mbed.h is a library made by mbed.org that contains 
classes/functions designed to make programming mbed 
microcontrollers easier */
#include "mbed.h"
/* #include tells the compiler to include TimedMovement.h
and TimedMovement.cpp in the program */
#include "TimedMovement.h" 

/* the main function is where a program will begin to execute. */

/****************************************************************
* Function: main()                                              *
*                                                               *
* Controls the movement of the RenBuggy by varying the speed    *
* of each motor                                                 *
*                                                               *
* Inputs: none                                                  *
*                                                               *
* Returns: none                                                 *
****************************************************************/
int main()
{
    /* here we can call the functions defined in TimedMovement.h
    and TimedMovement.cpp, and specify the length of time we want
    them to run for by passing a variable which represents a 
    length of time in seconds */
    forward(5.5);
    hold(16);
    readButton(11);
    forward(3);
    left(2);
    right(6.5);
    forward(3);
    hold(5);
    
    right(0.25);
    for (int i = 0;i<6;i++)
    {
        left(0.5);
        right(0.5);
    }
    left(0.25);
    forward(1.0);
    
}