
// ----------------------------------------------------------------------
// LaserMon-Main.h
//
// Fredric L. Rice, June 2019
//
// ----------------------------------------------------------------------

#define TEST_SIGNAL_OUT     PA_5
#define LASER_SCAN_IN       PC_1
#define TEC_VOLTAGE_IN      PC_3
#define USE_SERIAL_TX       PA_9
#define USE_SERIAL_RX       PA_10

// ----------------------------------------------------------------------
// Defined constants and MACROs
//
// ----------------------------------------------------------------------

// For some purposes we may want to know the dimentions of the screen
#define LCD_WIDTH               240
#define LCD_HEIGHT              320

// This describes how many pixels to the right we start plotting porch
#define INITIAL_PORCH_HEIGHT    50

// ----------------------------------------------------------------------
// Describe data which we export to all other modules
//
// ----------------------------------------------------------------------

    // We may be accessing the LCD
    extern LCD_DISCO_F429ZI st_lcd;

    // We may be accessing the touch screen
    extern TS_DISCO_F429ZI st_touchScreen;

// ----------------------------------------------------------------------
// Function prototypes that Main will export globally
//
// ----------------------------------------------------------------------

extern void LaserMonMainInformScanInformation(uint16_t u16_scanLength, uint16_t u16_scanCount);
extern void LaserMonMainInformTECVoltage(uint16_t u16_thisVoltage);

// End of file

    