
// ----------------------------------------------------------------------
// SecurityUnlockDemo-Keypad.h
//
// Fredric L. Rice, June 2019
//
// ----------------------------------------------------------------------

#ifndef _SECURITYUNLOCKDEMOKEYPAD_H_
#define _SECURITYUNLOCKDEMOKEYPAD_H_      1

// ----------------------------------------------------------------------
// Describe MACROs which the module may use
//
// ----------------------------------------------------------------------

// We define this value to position the entire keypad on the screen
#define KEYPAD_LEFT_MARGIN      42
#define KEYPAD_TOP_MARGIN       60

// The "line number" on the display to show the keys that get entered
#define ENTERED_KEYS_LINE       18

// We allow the operator to enter a maximum number of digits for
// the access code
#define MAX_SECURITY_DIGITS     15

    // We define the format of the keypad data structure which the
    // module will use to describe the placement of each key
    typedef struct KeypadLocation
    {
        uint16_t u16_screenXLocation;
        uint16_t u16_screenYLocation;
        uint16_t u16_keyHeight;
        uint16_t u16_keyWidth;
        uint8_t  u8_keyASCIICharacter;
    } KeypadLocation_t;

// ----------------------------------------------------------------------
// Function prototypes that we will export
//
// ----------------------------------------------------------------------

extern void KeypadInit(void);
extern void KeypadHandleKeyPress(uint16_t u16_screenX, uint16_t u16_screenY);
extern void KeypadDrawKeypad(void);

#endif

// End of file

