
// ----------------------------------------------------------------------
// SecurityUnlockDemo-Animation.h
//
// Fredric L. Rice, June 2019
//
// ----------------------------------------------------------------------

#ifndef _SECURITYUNLOCKDEMOANIMATION_H_
#define _SECURITYUNLOCKDEMOANIMATION_H_      1

// ----------------------------------------------------------------------
// Defined constants that the module might use
//
// ----------------------------------------------------------------------

#define SPRITE_HEIGHT_IN_PIXELS     17

// ----------------------------------------------------------------------
// We allow the following sprite movement directions
//
// ----------------------------------------------------------------------
#define SPRITE_DIRECTION_LEFT_UP        1
#define SPRITE_DIRECTION_UP             2
#define SPRITE_DIRECTION_RIGHT_UP       3
#define SPRITE_DIRECTION_LEFT           4
#define SPRITE_DIRECTION_NOT_VALID      5
#define SPRITE_DIRECTION_RIGHT          6
#define SPRITE_DIRECTION_LEFT_DOWN      7
#define SPRITE_DIRECTION_DOWN           8
#define SPRITE_DIRECTION_RIGHT_DOWN     9

// ----------------------------------------------------------------------
// We allow the sprite to move around the screen within certain boundary
// positions which are defined here.
//
// ----------------------------------------------------------------------
#define SPRITE_MINIMUM_X                50
#define SPRITE_MAXIMUM_X                LCD_WIDTH - 30
#define SPRITE_MINIMUM_Y                60
#define SPRITE_MAXIMUM_Y                LCD_HEIGHT - 30

// ----------------------------------------------------------------------
// Function prototype this module will export
//
// ----------------------------------------------------------------------

extern void AnimationInit(void);
extern void AnimationPerformAnimation(uint32_t u32_randomSeeder);
extern void AnimationStopAnimation(void);

#endif

// End of file

