/*
    Le main permet d'instancier les différentes classes développées.
    C'est dans ce ficher que l'on défini le mot à trouver ainsi que 
    les interuptions permettant à l'utilisateur d'interagir avec 
    l'écran grâce aux boutons.
*/

// Importation des librairies utilisées

#include "mbed.h"
#include "SeeedGrayOLED.h"
#include "AnalyseurMot.h"
#include "Lettre.h"
#include <iostream>

using namespace std;

// Instanciation des objets utilisés

InterruptIn button1(p15);
InterruptIn button2(p16);
SeeedGrayOLED *seeedGrayOled = new SeeedGrayOLED(p9, p10);
Lettre *lettre = new Lettre();
char motMystere[8]={'P','O','L','Y','T','E','C','H'};
char motEssai[8]={'_','_','_','_','_','_','_','_'};
AnalyseurMot *analyseurMot = new AnalyseurMot(motMystere,motEssai);

// Interruption permettant de changer l'affichage de la lettre en
// appuyant sur le boutton 1

void flip1()
{
    if(button1)
    { 
        lettre->setLettre();
        wait(0.25);
    }
}

// Interruption permettant de valider le choix de la lettre en appuyant
// sur le boutton 2 ce qui effectue une comparaison avec les lettres du
// mot mystère

void flip2()
{
    if(button2)
    {
        analyseurMot->comparerMot(lettre->getLettre(),8);
        wait(0.25);
    }
}

// Fonction d'initialisation de l'écran OLED

void initialisationHard()
{
    seeedGrayOled->init();             
    seeedGrayOled->clearDisplay();     
    seeedGrayOled->setNormalDisplay(); 
    seeedGrayOled->setVerticalMode();    
}

// Affichage des informations sur l'écran OLED, 3 possibilités :
// 1. Le nombre d'essais est nul, l'écran affiche la défaite
// 2. Le mot mystère a été trouvé, l'écran affiche la victoire
// 3. En cours de jeu, l'écran affiche les informations utiles au joueur

void afficherMessage()
{
    if (analyseurMot->getLvlBar()==0)
    {
        initialisationHard();
        seeedGrayOled->setTextXY(3,2);
        seeedGrayOled->putString("Vous avez");
        seeedGrayOled->setTextXY(5,2);
        seeedGrayOled->putString("PERDU !!!");    
    }
    else if ((analyseurMot->getMotEssai())==(analyseurMot->getMotMystere()))
    {
        initialisationHard();
        seeedGrayOled->setTextXY(3,2);
        seeedGrayOled->putString("Vous avez");
        seeedGrayOled->setTextXY(5,2);
        seeedGrayOled->putString("GAGNE !!!"); 
    }
    else
    {
        seeedGrayOled->setTextXY(1,0);
        seeedGrayOled->putString("Selection :");
        seeedGrayOled->setTextXY(3,5);
        seeedGrayOled->putChar(lettre->getLettre());
        seeedGrayOled->setTextXY(6,0);
        seeedGrayOled->putString("Mystery :");
        seeedGrayOled->setTextXY(8,2);
        seeedGrayOled->putString(analyseurMot->getMotEssai());
    }
}

// La fonction main permet le fonctionnement du programme, il intègre 
// l'initialisation, les adresses d'interruptions, la boucle d'affichage
// et supprime les objets instanciés en dynamique.

int main()
{
    initialisationHard();
    button1.rise(&flip1);
    button2.rise(&flip2);
    
    while(1)
    {
        afficherMessage();   
    }
    
    delete motMystere;
    delete motEssai;
    delete lettre;
    delete analyseurMot;
    delete seeedGrayOled;
}