#include "AnalyseurMot.h"

LED_Bar bar(p6, p5);

using namespace std;

// Constructeur de la classe permettant d'initialiser les pointeurs
// sur le mot à trouver défini dans le main ainsi que le mot en cours
// de traitement par le joueur
// Initialise le Led barre à son maximum (10)

AnalyseurMot::AnalyseurMot(char * motMystere, char * motEssai)
{
    _motEssai = motEssai;
    _motMystere = motMystere;
    _lvlBar=10;
    bar.setLevel(_lvlBar);
}

// Destructeur de la classe

AnalyseurMot::~AnalyseurMot()
{    
}

// Méthode permettant de comparer le mot que le joueur est en train 
// de manipuler avec le mot à trouver
// Si la lettre choisi par le joueur est dans le mot à trouver,
// celle-ci est placée dans le mot manipulé, dans le cas contraire
// le Led barre perd une led

void AnalyseurMot::comparerMot(char lettre, int nbrLettre)
{    
    int i;
    int j=0;
    for(i=0;i<nbrLettre;i++)
    {
        if (_motMystere[i]==lettre)
        {
            _motEssai[i]=lettre;
            j=1;
        }
    }
    if (j==0&&_lvlBar>0) 
    {
        _lvlBar--;
        bar.setLevel(_lvlBar);
    }    
}

// Méthode qui retourne le mot manipulé par le joueur

char* AnalyseurMot::getMotEssai(void)
{
    return _motEssai;           
}

// Méthode qui retourne le mot à trouver

char* AnalyseurMot::getMotMystere()
{
    return _motMystere;
}

// Méthode qui retourne le niveau du Led barre

int AnalyseurMot::getLvlBar(void)
{
    return _lvlBar;
}