#include "mbed.h"
#include "rtos.h"
#include "Grove_LCD_RGB_Backlight.h"

#define SDA_I2C p28
#define SCL_I2C p27

#define SIG_RX_CAN  0x01

DigitalOut led1(LED1);
DigitalOut led2(LED2);
Grove_LCD_RGB_Backlight Afficheur(SDA_I2C,SCL_I2C);

Thread threadA;
Thread threadB;
 
CAN CanPort(p30, p29);
CANMessage  MessageRx; 
CANMessage  MessageTx;

unsigned int    Id;

void canReader(void)
{      
    if (CanPort.read(MessageRx))
    {
            led1 = !led1;
            threadA.signal_set(SIG_RX_CAN);
    }
} 
 
void affichage()
{
    switch(MessageRx.id)
    {    
        case '0x011' :
            printf("Temperature 1");
        break;
        
        case '0x021' :
            printf("Humidite");
        break;
    
        case '0x031' :
            printf("Temperature et Humidite");
        break;
        
        case '0x111' :
            printf("Trop chaud");
        break;
        
        case '0x112' :
            printf("Temperature normale");
        break;
        
        case '0x113' :
            printf("Trop froid");
        break;
        
        case '0x012' :
            printf("Temperature 2");
        break;
        
        case '0x041' :
            printf("Pression atmosphérique");
        break;
        
        case '0x051' :
            printf("Temperature 2 et Pression");
        break;
        
        case '0x141' :
            printf("Orageux");
        break;
        
        case '0x142' :
            printf("Nuageux");
        break;
        
        case '0x143' :
            printf("Dégagé");
        break;
        
        case '0x081' :
            printf("Luminosité");
        break;
        
        case '0x181' :
            printf("Jour");
        break;
        
        case '0x182' :
            printf("Nuit");
        break;
    }
}   

void requeteATous() // Requete demandant toutes les données
{
    MessageTx.id=0x000;
    
}

void requeteTempHum()
{
    MessageTx.id=0x031;    
}

void requeteTempPress()
{
    MessageTx.id=0x051;    
}

void requeteLum()
{
    MessageTx.id=0x081;
}


void thA() 
{
    while(true)
    {
        Thread::signal_wait(SIG_RX_CAN);    
        led2 = !led2;
        affichage();
    }
}
 
void thB() 
{
    while (true) 
    {
    CanPort.write(MessageTx);
        requeteATous();
        wait(1800000);   
    }
}

void thC() 
{
    while (true) 
    {
    CanPort.write(MessageTx);
        requeteLum();
        wait(900000);   
    }
}

void thD() 
{
    while (true) 
    {
    CanPort.write(MessageTx);
        requeteTempHum();
        wait(600000);   
    }
}

void thE() 
{
    while (true) 
    {
    CanPort.write(MessageTx);
        requeteTempPress();
        wait(600000);   
    }
}

int main() 
{
    wait(0.5);
    Afficheur.clear();
    Afficheur.print("Hello");
    Afficheur.setRGB(255, 255, 255);
    
    CanPort.frequency(20000);
    
    //Id = 0x1A5;
    //MessageTx.len=2;
    //MessageTx.data[0] = 0x55;
    //MessageTx.data[1] = 0xAA;
    
    //MessageTx.format = CANStandard;
    //MessageTx.format = CANExtended;
    
    //MessageTx.type = CANData;
    //MessageTx.type = CANRemote;
    
    CanPort.attach(canReader,CAN::RxIrq);
        
    threadA.start(thA);
    threadB.start(thB);
    
    led1 = 0;
    printf("Start OK\n");
    
    while (true) 
        {
    
        }
}
