#include "mbed.h"
#include "FXOS8700Q.h"
 
//I2C line for FXOS8700Q accelerometer
FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);
//I2C line for FXOS8700Q magnetometer
FXOS8700Q_mag mag( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);
 
//Terminal communication init.
Serial pc(USBTX, USBRX);
 
//Accelerometer data variables
//MotionSensorDataUnits mag_data;
//MotionSensorDataUnits acc_data;
 

int main() 
{
    float accelX, accelY, accelZ;
    float magnetoX, magnetoY, magnetoZ;
    
    //Enable Accelerometer
    acc.enable();
    printf("\r\n\nFXOS8700Q Address on I2C bus = %X\r\n", acc.whoAmI());

    while (true) 
    {   
        /* GET AXIS VALUES FROM ACCELEROMETER AND MAGNETOMETER*/
        acc.getX(&accelX);
        //acc.getY(&accelY);
        //acc.getZ(&accelZ);
        //mag.getX(&magnetoX);
        //mag.getY(&magnetoY);
        //mag.getZ(&magnetoZ);
        /* SCALE AXIS VALUES TO DEGREES*/
        accelX *= 90;
        //accelY *= 180;
        //accelZ *= 180;
        /* PRINT THOSE VALUES */
        //printf("FXOS8700Q ACC: X=%1.2f' Y=%1.2f' Z=%1.2f'  ", accelX, accelY, accelZ);
        //printf("   MAG: X=%4.1f Y=%4.1f Z=%4.1f\r\n", magnetoX, magnetoY, magnetoZ);
        printf("AccelX: %1.2f\n\r",accelX);
        wait(1.0); //delay
    }
}