#ifndef mdc_h
#define mdc_h

#define     MOTOR_FREE                  0x00
#define     MOTOR_FORWARD               0x01
#define     MOTOR_BACK                  0x02
#define     MOTOR_STOP                  0x03

#define SPD_MINUS   0
#define SPD_H       1
#define SPD_M       2
#define SPD_L       3
#define COUNT_MINUS 4
#define COUNT_SPIN  5
#define ANGLE_MINUS 6
#define ANGLE_H     7
#define ANGLE_M     8
#define ANGLE_L     9
#define NUM         4

#define DPI         6.2832

#include "mbed.h"

class motor{
    public:
        motor(I2C &i2c, int addr);
        int move(float pwm = 1000);
        void reset();
//enc-------------------------------------------------------------------
        int count;
        
        float angle();
        
        float angle_data;
        float position_data;
//-----------------------------------------------------------------------------
        char data[2];
    private:
        char data_reset[2];
        char md_data[2];
        
        void result();
        int write_pwm;
        int val;
        int address;
        
        float encoder_spd;
        float position_angle;
        
        I2C mdc_i2c;
};

#endif