#include "mbed.h"
#include "math.h"
#include "mdc.h"

extern I2C mdc_i2c;

motor::motor(I2C &i2c, int addr): mdc_i2c(i2c)
{
    address = addr;
    data[0] = 0;
    data[1] = 0;
    data_reset[0] = 0xff;
    data_reset[1] = 0;
    val = 1;
}

int motor::move(float pwm){
    write_pwm = (int)(pwm*127);
    if(pwm == 1000){
        md_data[0] = MOTOR_FREE;
        write_pwm = 0;
    }
    else if(write_pwm < 0){
        md_data[0] = MOTOR_BACK;
        write_pwm = abs(write_pwm);
    }
    else if(write_pwm > 0){
        md_data[0] = MOTOR_FORWARD;
    }
    else if(write_pwm == 0){
        md_data[0] = MOTOR_STOP;
        write_pwm = 0;
    }
    
    md_data[1] = write_pwm;
    
    int val = mdc_i2c.write(address,md_data,2,false);
    return (val);
}

void motor::reset(){
    mdc_i2c.write(address,data_reset,2);
}

//角度を算出して角度を返す(回転数も考慮
float motor::angle(){
    val = mdc_i2c.read(address,data,2,false);
    
    count = (int)(data[0]) - 128;
    
    position_data = (int)(data[1])*3.6;
    angle_data = (float)count*36 + position_data/10;
    
    return angle_data;
}
