#include "mbed.h"
#include "LCD.h"

lcd::lcd(I2C &i2c): _i2c(i2c){}

void lcd::setup(){
    wait(0.1);
    write_command(0x38);
    write_command(0x39);
    write_command(0x14);
    write_command(0x73);
    write_command(0x56);
    write_command(0x6C);
    wait(0.05);
    write_command(0x38);
    write_command(0x01);
    write_command(0x0C);
}
void lcd::write_data(uint16_t t_data){
    data[0] = 0x40;
    data[1] = t_data;
    write_i2c(data,2);
    wait(0.001);
}
void lcd::set_cursor(int stage, int len){
    write_command(len+(0x40*stage)+0x80);
}

void lcd::print(char data[100], int stage, int length){
    if(stage != NODATA && length != NODATA)
        set_cursor(stage,length);
    int len = 0;
    while(!(NULL == *(data+len))){
        len++;
    }
    for(int i=0;i < len;i++){
        write_data(data[i]);
    }
}

void lcd::write_i2c(char *_data,int size){
    val = _i2c.write(0x7C,_data,size,false);
}
void lcd::write_command(uint16_t _data){
    data[0] = 0x00;
    data[1] = _data;
    write_i2c(data,2);
    wait(0.01);
}

void lcd::clear(int stage_0, int stage_1){
    if(stage_0)
        print("                ",0,0);
    if(stage_1)
        print("                ",1,0);
}
