#ifndef LCD_h
#define LCD_h

#include "mbed.h"

#define NODATA  0xFF

class lcd{
    public:
        lcd(I2C &i2c);
        void setup();
        
        void set_cursor(int stage, int len);
        void print(char data[100],int stage = NODATA, int length = NODATA);
        void clear(int stage_0 = 1, int stage_1 = 1);
    private:
        I2C _i2c;
        int val;
        char data[2];
        
        void write_i2c(char *_data, int size);
        void write_data(uint16_t t_data);
        void write_command(uint16_t _data);
};

#endif