/* WiFi Example
 * Copyright (c) 2016 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <ios>
#include <stdio.h>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstream, std::stringbuf
#include <vector>
#include <iomanip>


#include "mbed.h"
#include "TCPSocket.h"

//#include "PHX/phxSocket.h"
//#include "PHX/phxChannel.h"
//#include "PHX/phxMessage.h"
#include "Websocket.h"
#include "MbedJSONValue.h"
#include "Json.h"

#define WIFI_ESP32      3
#define TOP      D5


//#elif TARGET_GR_LYCHEE
#include "ESP32Interface.h"
ESP32Interface wifi(P5_3, P3_14, P7_1, P0_1);
/*
#else // External WiFi modules

#if MBED_CONF_APP_WIFI_SHIELD == WIFI_ESP8266
#include "ESP8266Interface.h"
ESP8266Interface wifi(MBED_CONF_APP_WIFI_TX, MBED_CONF_APP_WIFI_RX);
#elif MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1
#include "SpwfSAInterface.h"
SpwfSAInterface wifi(MBED_CONF_APP_WIFI_TX, MBED_CONF_APP_WIFI_RX);
#elif MBED_CONF_APP_WIFI_SHIELD == WIFI_ESP32
#include "ESP32Interface.h"
ESP32Interface wifi(MBED_CONF_APP_WIFI_EN, MBED_CONF_APP_WIFI_IO0, MBED_CONF_APP_WIFI_TX, MBED_CONF_APP_WIFI_RX);
#endif

#endif*/

// Blinky
DigitalOut led(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

PwmOut pin(D5);

int main()
{
    int count = 0;

    printf("WiFi example\n\n");

    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error\n");
        return -1;
    }

    printf("Success\n\n");
    printf("MAC: %s\n", wifi.get_mac_address());
    printf("IP: %s\n", wifi.get_ip_address());
    printf("Netmask: %s\n", wifi.get_netmask());
    printf("Gateway: %s\n", wifi.get_gateway());
    printf("RSSI: %d\n\n", wifi.get_rssi());

    printf("Daredevil Websocket 0.1\r\n");
    printf("Opening Websocket\n");

    Websocket ws("ws://dlevs.me:4000/socket/websocket", &wifi);
    int connect_error = ws.connect();


// ******* ITEMS TO BE REUSED A BUNCH *********/
    MbedJSONValue message;
    std::string s;

    MbedJSONValue heartbeat;
    MbedJSONValue messageM;
    MbedJSONValue bodyM;
    int counter = 0;
    //char buf[50];
// *************** END **********************/



    // ******* CONNECTING  *********/
    //fill the object
    message["topic"] = "room:lobby";
    message["event"] = "phx_join";
    message["payload"] = "";
    message["ref"] = "";

    //serialize it into a JSON string
    s = message.serialize();
    //printf("json: %s\r\n", s.c_str());

    //make non constant string to send

    //char* pc;
    std::vector<char> v(s.length() + 1);
    std::strcpy(&v[0], s.c_str());
    //pc = &v[0];


    char recvbuffer[32];
    int error_c = ws.send(&v[0]);


    wait(1.0);

    if (ws.read(recvbuffer)) {
      printf("rcv: %s\r\n", recvbuffer);
      memset(recvbuffer, 0, sizeof(recvbuffer));
      //recvbuffer.clear();
    }


    // ******* END CONNECTING  *********/


    // begin main loop
    while (true) {

        // blink...
    led3 = !led3;
    led4 = !led4;
        wait(0.2);

    std::string my_str;
    std::string my_stringo;
    int my_int;
    bool my_bool;

    MbedJSONValue demo;
    MbedJSONValue payload;
    MbedJSONValue body;

    if (ws.read(recvbuffer)) {
      led = !led;
      led2 = !led2;
          printf("rcv: %s\r\n", recvbuffer);

      //parse(demo, recvbuffer);

      Json json (recvbuffer, strlen ( recvbuffer ) );

      if ( !json.isValidJson () )
        {
          printf( "Invalid JSON: %s", recvbuffer);
        }

      if ( json.type (0) != JSMN_OBJECT )
        {
          printf("Invalid JSON.  ROOT element is not Object: %s", recvbuffer);
        }

      // Let's get the value of key "city" in ROOT object, and copy into
      // payload
      char payloadValue [256];
      int payloadKeyIndex = json.findKeyIndexIn ( "payload", 0 );


      if ( payloadKeyIndex == -1 )
        {
          // Error handling part ...
          printf( "\"payload\" does not exist ... do something!!" );
        }
      else
        {
          // Find the first child index of key-node "city"
          int payloadValueIndex = json.findChildIndexOf ( payloadKeyIndex, -1 );
          if ( payloadValueIndex > 0 )
        {
          const char * valueStart  = json.tokenAddress ( payloadValueIndex );
          int          valueLength = json.tokenLength ( payloadValueIndex );
          strncpy ( payloadValue, valueStart, valueLength );
          payloadValue [ valueLength ] = 0; // NULL-terminate the string

          //let's print the value.  It should be "San Jose"
          printf( "payload: %s\n", payloadValue );
        }
        }



      //now look for event top or bottom
      // and then pull out the body
      Json json2 ( payloadValue, strlen (payloadValue) );
      char eventValue[32];
      char bodyValue[32];

      int eventKeyIndex = json2.findKeyIndexIn ( "event", 0 );
      int bodyKeyIndex = json2.findKeyIndexIn ( "body", 0 );

      int eventValueIndex = json2.findChildIndexOf ( eventKeyIndex, -1 );
      int bodyValueIndex = json2.findChildIndexOf ( bodyKeyIndex, -1 );

      if ( eventValueIndex > 0 )
        {
          const char * valueStart  = json2.tokenAddress ( eventValueIndex );
          int          valueLength = json2.tokenLength ( eventValueIndex );
          strncpy ( eventValue, valueStart, valueLength );
          eventValue [ valueLength ] = 0; // NULL-terminate the string

          //let's print the value.  It should be "San Jose"
          printf( "event: %s\n", eventValue );
        }

      if ( bodyValueIndex > 0 )
        {
          const char * valueStart  = json2.tokenAddress ( bodyValueIndex );
          int          valueLength = json2.tokenLength ( bodyValueIndex );
          //std::string strinly(bodyValue);
          /*          printf("%i\n",valueStart);
          printf("%i\n",valueLength);
          printf("%s\n",strinly);*/

          strncpy ( bodyValue, valueStart, valueLength );
          bodyValue [ valueLength ] = 0; // NULL-terminate the string

          //let's print the value.  It should be "San Jose"
          printf( "body: %s\n", bodyValue );

          // OLD ATTEMPT THAT LEADS TO STACKOVERFLOW:
          // using namespace std;
          // string str(bodyValue);
          // istringstream iss(bodyValue);
          // vector<string> tokens;
          // copy(istream_iterator<string>(iss),
          //    istream_iterator<string>(),
          //    back_inserter(tokens));

          //  std::cout << "myvector contains:";
          //   for (unsigned i=0; i<tokens.size(); i++)
          //     std::cout << ' ' << tokens.at(i);
          //   std::cout << '\n';

          // NEW ATTEMPT BASED ON QUORA ANSWER
          // std::vector<std::string> result;

          // std::istringstream iss(bodyValue);
          // for(std::string val; iss >> val; ) {
          //   result.push_back(val);
          // }


          // std::cout << "myvector contains:";
          // for (unsigned i=0; i<result.size(); i++) {
          //   std::cout << ' ' << result.at(i);
          //   std::cout << '\n';

          // ATTEMPT 3 W/ strtok http://www.cplusplus.com/reference/cstring/strtok/
          // `${topspeed} ${topdirection} ${topstop} ${bottomspeed} ${bottomdirection} ${bottomstop}`
          char* topspeed = strtok(bodyValue, " ");
          char* topdirection = strtok(NULL, " ");
          char* topstop = strtok(NULL, " ");
          char* bottomspeed = strtok(NULL, " ");
          char* bottomdirection = strtok(NULL, " ");
          char* bottomstop = strtok(NULL, " ");
          printf( "topspeed: %s\n", topspeed );
          printf( "topdirection: %s\n", topdirection );
          printf( "topstop: %s\n", topstop );
          printf( "bottomspeed: %s\n", bottomspeed );
          printf( "bottomdirection: %s\n", bottomdirection );
          printf( "bottomstop: %s\n", bottomstop );
      }


      //my_str = demo["payload"].get<std::string>();

      //parse(payload,my_str);
      //my_stringo = payload();

      /*std::vector<char> b(s.length() + 1);
      std::strcpy(&b[0], s.c_str());

      error_c = ws.send(&b[0]);

      std::vector<char> zeroVec;
      b.swap(zeroVec);*/



      //printf("%s",payload);


      memset(recvbuffer, 0, sizeof(recvbuffer));
      //recvbuffer.clear();
      }

    //std::string my_str;
    // int my_int;
    // bool my_bool;

      //      my_str = demo[""][0].get<std::string>();
      //my_int = demo["my_array"][1].get<int>();
      //my_bool = demo["my_boolean"].get<bool>();




    //  MbedJSONValue heartbeat;
    //  std::string s;

    //fill the object
    /*  heartbeat["topic"] = "phoenix";
    heartbeat["event"] = "heartbeat";
    heartbeat["payload"] = "";
    heartbeat["ref"] = "0";

    //message["my_boolean"] = false;

    //serialize it into a JSON string
    s = heartbeat.serialize();
    //printf("json: %s\r\n", s.c_str());

    std::vector<char> b(s.length() + 1);
    std::strcpy(&b[0], s.c_str());

    error_c = ws.send(&b[0]);

    std::vector<char> zeroVec;
    b.swap(zeroVec);*/



    //Sample Object to fill
    /*messageM["topic"] = "room:lobby";
    messageM["event"] = "touch";
    itoa (rand(),buf,10);
    bodyM["body"] = "miracles happen sometimes";
    messageM["payload"] = bodyM;//&m[0];
    messageM["ref"] = "";*/

    //std::vector<char> m(s.length() + 1);
    //std::strcpy(&m[0], s.c_str());

    //message["my_boolean"] = false;

    //serialize it into a JSON string
    //s = messageM.serialize();

    //std::vector<char> n(s.length() + 1);
    //std::strcpy(&n[0], s.c_str());


    //error_c = ws.send(&n[0]);

    //freeing memory
    //std::vector<char> zeroVec;
    //n.swap(zeroVec);


    //delete [] &n;
    //delete [] &messageM;
    //delete [] &bodyM;

    /*  char *recv;*/

    /*  if (ws.read(recvbuffer)) {
      led = !led;
      led2 = !led2;
      printf("rcv: %s\r\n", recvbuffer);
      memset(recvbuffer, 0, sizeof(recvbuffer));
      }*/


    counter++;
    printf("count: %i\n",counter);
  }

    wifi.disconnect();

    printf("\nDone\n");
}
