#include "mbed.h"
#include "SDBlockDevice.h"
#include "iostream"
#include "stdio.h"
#include "string"
#include "vector"
#include <errno.h>
#include "HeapBlockDevice.h"
#include "platform/CircularBuffer.h"

//For saving funny int formats
#include <inttypes.h>

// File systems
//#include "LittleFileSystem.h"
#include "FATFileSystem.h"

class SDCardReader:public SDBlockDevice{
    public:
        SDCardReader(PinName a=MBED_CONF_SD_SPI_MOSI, PinName b=MBED_CONF_SD_SPI_MISO, PinName c=MBED_CONF_SD_SPI_CLK, PinName d=MBED_CONF_SD_SPI_CS):SDBlockDevice(a, b, c, d){
    m_fs = new FATFileSystem("fs");
  };
        	
  	FILE* openFile(string filename);
	void closeFile(FILE* fileToClose);

	int writeDataPoint(FILE* theFile, int index, uint32_t timestamp, vector<uint16_t> data);
	int eraseData();

	int fullWriteProcedure(string filename,vector<int> indexArr, vector<uint32_t> timeArr, vector<vector <uint16_t> > allData);
		
	void mountFileSystem();
	void unmountFileSystem();


	//Read and increment for keeping track of SDcard files
	//Each file gets a new number
	int readAndIncrement(string filename); 

	
    private:

	void write_uint16_t(uint16_t data, bool endline, FILE* fileToUse);
	void write_uint32_t(uint32_t data, bool endline, FILE* fileToUse);

	// Define file system
        FATFileSystem* m_fs;
};
