#ifndef _DATARECORDER_H_
#define _DATARECORDER_H_

#include "mbed.h"
#include "platform/CircularBuffer.h"
#include "sdCardReader.h"


//converts number to string
#include <sstream>
#define SSTR( x ) static_cast< std::ostringstream & >(( std::ostringstream() << std::dec << x ) ).str()

// Define circular buffer size
#define BUF_SIZE    10000


/** Data Recorder is a class that stores data measurements in a ring buffer. 
It contains an SD Card Reader with a filesystem to store measurements when required  **/

class DataRecorder{
  public:
  DataRecorder(int numDataFields);
    /** Get Information **/
    // gets the number of values stored in the circular buffer
    int getDataQuantity();
    int getTimeStampQuantity();
    
    // pops the last value off of the circular buffer 
    uint16_t popLastDataPoint();
    uint32_t popLastTimeStamp();

    /** Set Information **/
    void logDistancePoint(uint16_t value);
    void logTimeStamp(uint32_t value);
 
    /** Save logged data to SD card **/
    void saveLoggedData(string filename);
    //saves buffer to sd card and clears it    
    void saveLoggedDataAndClearBuffer(string filename);

    int getTrialNumAndIncrement();

    
  private:

    void savePoint(uint16_t value);
    // input values are converted to char arrays
    // iterate over char array to add values to buffer
    // buffer contents it turned into a uint8_t array and written to 
    // sd card

    /* Buffers for Data Storage */
    CircularBuffer<uint16_t, BUF_SIZE> m_buf_data;
    CircularBuffer<uint32_t, BUF_SIZE> m_buf_timestamp;

    // Count for buffers
    int m_data_quantity;
    int m_time_quantity;
    
    /* SD Card Interface Object  */
    SDCardReader* m_saveBuddy;
    
    int m_numDataFields;



    
    //specialized buffers
    //CircularBuffer<uint16_t, BUF_SIZE> buf_distance;
    //CircularBuffer<uint16_t, BUF_SIZE> buf_kalmanAngle;
    //CircularBuffer<uint32_t, BUF_SIZE> buf_timestamp;
    
    /*CircularBuffer<char, BUF_SIZE> buf_accX;
    CircularBuffer<char, BUF_SIZE> buf_accY;
    CircularBuffer<char, BUF_SIZE> buf_accZ;
    CircularBuffer<char, BUF_SIZE> buf_gyroX;
    CircularBuffer<char, BUF_SIZE> buf_gyroY;
    CircularBuffer<char, BUF_SIZE> buf_gyroZ;*/
    
    //sdcard blocks
    //uint8_t blockDistance[4096];
    //int blockDistance_Index;

    // clear pops all elements out of buffer.
    /*CircularBuffer<char, BUF_SIZE> buf;
    char data_stream[];// = "DataToBeAddedToBuffer";
    uint32_t bytes_written;// = 0;
    int m;
    const uint8_t separator = ' ';*/
    
};


#endif
