#include "sdCardReader.h"


//helpers
int getSize(int* p){
  printf("reg p %i \n",sizeof(p));
  printf("star p %i \n",sizeof(*p));
  
  return (sizeof(p)/sizeof(*p));
}

int getSize(uint16_t* p){
  return (sizeof(p)/sizeof(*p));
}

//private essential methods
// Try to mount the filesystem
void SDCardReader::mountFileSystem(){
    printf("Mounting the filesystem... ");
    fflush(stdout);
    int err = m_fs->mount(this);
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        // Reformat if we can't mount the filesystem
        // this should only happen on the first boot
        printf("No filesystem found, formatting... ");
        fflush(stdout);
        err = m_fs->reformat(this);
        printf("%s\n", (err ? "Fail :(" : "OK"));
        if (err) {
            error("error: %s (%d)\n", strerror(-err), err);
        }
    }
}

void SDCardReader::unmountFileSystem(){
  printf("Unmounting... ");
  fflush(stdout);
  int err = m_fs->unmount();
  printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
  if (err < 0) {
    error("error: %s (%d)\n", strerror(-err), err);
  } 
}


FILE* SDCardReader::openFile(string filename){
  printf("Opening \"/fs/%s\"... ",filename.c_str());
  fflush(stdout);
  FILE *f = fopen(filename.c_str(), "r+");
  printf("%s\n", (!f ? "Fail :(" : "OK"));
  if (!f) {
    // Create the file if it doesn't exist
    printf("No file found, creating a new file... ");
    fflush(stdout);
    f = fopen(filename.c_str(), "w+");
    printf("%s\n", (!f ? "Fail :(" : "OK"));
    if (!f) {
      error("error: %s (%d)\n", strerror(errno), -errno);
    }
  }
  return f;
}

void SDCardReader::write_uint16_t(uint16_t in_data, bool endline, FILE* fileToUse){
  FILE *f = fileToUse;
  printf("%s\n", (!f ? "Fail :(" : "OK"));

  int16_t data = (int16_t)in_data;
  
  //printf("\rWriting 16 bit value: % " PRIu16 " ", data);
  printf("\rWriting 16 bit value %i ", static_cast<int>(data));
  fflush(stdout);

  int err = 0;
  //write and check for error
  if (endline){
    err = fprintf(f,"%i\n",static_cast<int>(data));
    //err = fprintf(f,"%" PRIu16 "\n",data);
  }else{
    err = fprintf(f,"%i " ,static_cast<int>(data));
  }

  if (err < 0) {
    printf("Fail :(\n");
    error("error: %s (%d)\n", strerror(errno), -errno);
  }
}


void SDCardReader::write_uint32_t(uint32_t data, bool endline, FILE* fileToUse){
  FILE *f = fileToUse;
  printf("%s\n", (!f ? "Fail :(" : "OK"));

  //printf("\rWriting 32 bit value:  %" PRIu32 " ", data);
  printf("\rWriting 32 bit value %i ", static_cast<int>(data));
  fflush(stdout);

  int err = 0;
  //write and check for error
  if (endline){
    //err = fprintf(f,"%" PRIu32 "\n",data);
    err = fprintf(f,"%i\n",static_cast<int>(data));
  }else{
    err = fprintf(f,"%i ",static_cast<int>(data));
  }
  
  if (err < 0) {
    printf("Fail :(\n");
    error("error: %s (%d)\n", strerror(errno), -errno);
  } 
}


void SDCardReader::closeFile(FILE* fileToClose){
  // Close the file which also flushes any cached writes
  printf("Closing file...");
  fflush(stdout);

  int err = 0;
  err = fclose(fileToClose);
  printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
  if (err < 0) {
    error("error: %s (%d)\n", strerror(errno), -errno);
  } 
}

int SDCardReader::fullWriteProcedure(string filename,vector<int> indexArr, vector<uint32_t> timeArr, vector<vector <uint16_t> > allData){
  mountFileSystem();
  FILE* theFile = openFile(filename);

  printf("The size of indexArr is %i \n",indexArr.size());
  
  for (unsigned int i = 0; i< indexArr.size(); i++){
    writeDataPoint(theFile,indexArr[i],timeArr[i], allData[i]);
  }
  
  closeFile(theFile);
  unmountFileSystem();

  return 1;
}

//use circular buffers instead of strings
//write as 1st column, index. 2nd column timestamp. 3rd column data1. 4th data2. etc.
//pass in array of circular buffers 
int SDCardReader::writeDataPoint(FILE* theFile, int index, uint32_t timestamp, vector<uint16_t> data){
  //  FILE* theFile = openFile(filename);

  //write index
  write_uint16_t(index, false, theFile);
  //write timestamp
  write_uint32_t(timestamp, false, theFile);

  //write data
  for (unsigned int i = 0; i < data.size()-1; i++) {
    write_uint16_t(data[i], false, theFile);
  }
  write_uint16_t(data[data.size()-1], true, theFile);
  return 0;
}

int SDCardReader::eraseData(){
    printf("Initializing the block device... ");
    fflush(stdout);
    int err = this->init();
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    printf("Erasing the block device... ");
    fflush(stdout);
    err = this->erase(0, this->size());
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    printf("Deinitializing the block device... ");
    fflush(stdout);
    err = this->deinit();
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        error("error: %s (%d)\n", strerror(-err), err);
    }

    return err;
}

//Methods for reading sdcard files. Mostly to read off trial numbers
int SDCardReader::readAndIncrement(string filename){
  mountFileSystem();
  
  FILE* theFile = openFile(filename);
  // Get current stream position
  long pos = ftell(theFile);
  // Parse out the number 
  int32_t number;
  int32_t presentNumber;
  
  fscanf(theFile, "%d", &number);
  presentNumber = number;
  number += 1;
  //read lone value as int, return it
  // Seek to beginning of number
  fseek(theFile, pos, SEEK_SET);
  // Store number
  fprintf(theFile, "%d\n", number);
  // Flush between write and read on same file
  fflush(theFile);
  
  closeFile(theFile);
  unmountFileSystem();
  return (int)presentNumber;
}
   
