#include "dataRecorder.h"

/* CONSTRUCTOR*/
DataRecorder::DataRecorder(int numDataFields){
  //Initialize SDCard Reader Class
  m_saveBuddy = new SDCardReader();

  //Initialize data quantity as 0
  m_data_quantity = 0;

  //initialize num fields
  m_numDataFields = numDataFields;
}


/* PUBLIC METHODS */

int DataRecorder::getDataQuantity(){
  return m_data_quantity;
}

int DataRecorder::getTimeStampQuantity(){
  return m_time_quantity;
}


uint16_t DataRecorder::popLastDataPoint(){
  //printf("pop data\n");
  
  m_data_quantity--;
    if (m_data_quantity<0){
    m_data_quantity=0;
  }
    uint16_t poppedData;
    if(!m_buf_data.empty()){
      m_buf_data.pop(poppedData);
      return poppedData;
    }else{
      return (uint16_t)0;
    }
  
}

uint32_t DataRecorder::popLastTimeStamp(){
  //printf("pop time\n");
  m_time_quantity--;
  if (m_time_quantity<0){
    m_time_quantity=0;
  }

  uint32_t poppedData;
  if(!m_buf_timestamp.empty()){
    m_buf_timestamp.pop(poppedData);
    return poppedData;
  }else{
    return (uint16_t)0;
  }
  
}

void DataRecorder::logDistancePoint(uint16_t value){
  //printf("push distance\n");
  m_data_quantity++;
  if (m_data_quantity>BUF_SIZE){
    m_data_quantity=BUF_SIZE;
  }
  m_buf_data.push(value);
}

void DataRecorder::logTimeStamp(uint32_t value){
  //printf("push time\n");
  m_time_quantity++;
  if (m_time_quantity>BUF_SIZE){
    m_time_quantity=BUF_SIZE;
  }
  m_buf_timestamp.push(value);
}

//helpers
int getoSize(int* p){
  printf("reg p %i \n",sizeof(p));
  printf("star p %i \n",sizeof(*p));
  
  return (sizeof(p)/sizeof(*p));
}

int getoSize(uint16_t* p){
  return (sizeof(p)/sizeof(*p));
}


/** Save logged data to SD card **/
void DataRecorder::saveLoggedData(string filename){
  //iterate over buffer and use the sd card commands

  printf("before logging, data quantity is %i\n",m_data_quantity);
  
  int numPoints = m_data_quantity/m_numDataFields; //add check for timestamps

  printf("numPoints %i \n ",numPoints);
  
  vector<int> indexArr(numPoints);
  //int indexArr[numPoints];
  
  //index setting
  for (int i = numPoints-1; i >=0 ; i--){
    indexArr[i] = i;
  }

  vector<uint32_t> timeArr(numPoints); 
  vector<uint16_t> dataEntry(m_numDataFields); //created before loop to see if prevent data collision
  vector<vector <uint16_t> > allDataArr(numPoints); 
  
  //uint32_t timeArr[numPoints];
  //uint16_t* allDataArr[numPoints];

  for (int i = 0; i < numPoints; i++){
    //time aggregation
    timeArr[i] = popLastTimeStamp(); 
      
    //data aggregation
    //  vector<uint16_t> dataEntry(m_numDataFields);
    for (int j=0;j<m_numDataFields;j++){
        dataEntry[j] = popLastDataPoint();
	printf("%i\n",dataEntry[j]);
    }
    allDataArr[i] = dataEntry;
    // printf("%i\n",static_cast<int>(dataEntry[0]));
  }

  printf("Before launch! size test %i \n",indexArr.size());
  
  m_saveBuddy->fullWriteProcedure(filename,indexArr,timeArr,allDataArr); 
}
//saves buffer to sd card and clears it    
void DataRecorder::saveLoggedDataAndClearBuffer(string filename){
  saveLoggedData(filename);
  // then eraseBuffers();
}

int DataRecorder::getTrialNumAndIncrement(){
  return m_saveBuddy->readAndIncrement("/fs/trialNum.txt");
}
