#ifndef _ADAFRUIT_IS31FL3731_H_
#define _ADAFRUIT_IS31FL3731_H_

#include "mbed.h"
#include "Adafruit_GFX.h"
#include "I2Cdev.h"


#define ISSI_ADDR_DEFAULT 0x74

#define ISSI_REG_CONFIG  0x00
#define ISSI_REG_CONFIG_PICTUREMODE 0x00
#define ISSI_REG_CONFIG_AUTOPLAYMODE 0x08
#define ISSI_REG_CONFIG_AUDIOPLAYMODE 0x18

#define ISSI_CONF_PICTUREMODE 0x00
#define ISSI_CONF_AUTOFRAMEMODE 0x04
#define ISSI_CONF_AUDIOMODE 0x08

#define ISSI_REG_PICTUREFRAME  0x01

#define ISSI_REG_SHUTDOWN 0x0A
#define ISSI_REG_AUDIOSYNC 0x06

#define ISSI_COMMANDREGISTER 0xFD
#define ISSI_BANK_FUNCTIONREG 0x0B    // helpfully called 'page nine'

#define I2C_SDA P3_4//D14 
#define I2C_SCL P3_5//D15  

//I2Cdev* myDevI2C = new I2Cdev(); 

class Adafruit_IS31FL3731 : public Adafruit_GFX {
 public:
  Adafruit_IS31FL3731(uint8_t x=16, uint8_t y=9):Adafruit_GFX(x,y){
      I2Cdev* myDevI2C = new I2Cdev(); 
      myI2C = myDevI2C;
      };//, I2Cdev* theI2C=myDevI2C); 
  bool begin(uint8_t addr = ISSI_ADDR_DEFAULT);
  I2Cdev* myI2C;
  virtual void drawPixel(int16_t x, int16_t y, uint16_t color);
  void clear(void);

  void setLEDPWM(uint8_t lednum, uint8_t pwm, uint8_t bank = 0);
  void audioSync(bool sync);
  void setFrame(uint8_t b);
  void displayFrame(uint8_t frame);


 protected:
  void selectBank(uint8_t bank);
  void writeRegister8(uint8_t bank, uint8_t reg, uint8_t data);
  uint8_t readRegister8(uint8_t bank, uint8_t reg);
  uint8_t _i2caddr, _frame;
};

class Adafruit_IS31FL3731_Wing : public Adafruit_IS31FL3731 {
 public:
  Adafruit_IS31FL3731_Wing():Adafruit_IS31FL3731(16,9){
      //myboss = mainboss;
      };//I2Cdev* theI2C);
  virtual void drawPixel(int16_t x, int16_t y, uint16_t color);
};



#endif