#include "mbed.h"
#include "rtos.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "utility.h"


/*
    FLAG SCRITTURA SU SD CARD IN CORSO
*/
bool volatile start_writing;
/*
    PULSANTE
*/
bool volatile button_int_f;/* Flag pulsante pigiato */
InterruptIn user_button(USER_KEY_PIN);
/*
    OGGETTO FILE
*/ 
FILE *fp = NULL;
uint32_t file_index;//Indice che conteggia in maniera progressiva i record sul file
/* 
    SD Card
*/
SDBlockDevice sd(SDCARD_MOSI, SDCARD_MISO, SDCARD_SCK, SDCARD_CS, 8000000);
FATFileSystem fs("fs");
/*
    Bus SPI
*/
SPI spiHandler(SPI_MOSI, SPI_MISO, SPI_SCK);
DigitalOut spiADXL355cs(ADXL355_CS);// Pin di CS ADXL355
/*
    ADXL355 
*/
adxl355_handler adxl355_config =//Handler accelerometro  
{
    .measure_range = adxl355_2g,
    .out_data_rate = adxl355_250hz,
    .drdy_pin = ADXL355_DRDY,
    .int1_pin = NULL,
    .int2_pin = NULL,
    .int_config = {}
};
InterruptIn adxl355_int((PinName)adxl355_config.drdy_pin);// Interrupt su pin accelerometro
uint32_t adxl355_int_timestamp;//Timestamp registrato nella routine di interrupt
uint8_t  adxl355_int_index;//Numero di interrupt consecutivi
uint16_t adxl355_newData_error = 0;//Errore metodo
//uint8_t  adxl355_newData_sample = 0;//Conteggio dei sample acquisiti
uint32_t adxl355_newData_timestamp;//Timestamp rilevato al 5° sample
/* Dati locali temporanei ADXL355 */
//uint32_t adxl355_rawX_tmp = 0;
//uint32_t adxl355_rawY_tmp = 0;
//uint32_t adxl355_rawZ_tmp = 0;
//uint32_t adxl355_rawT_tmp = 0;
/*
    DEBUG PIN
*/
DigitalOut BLUpin(DBG_PIN_2);
DigitalOut YELLOWpin(DBG_PIN_4);
DigitalOut GREENpin(DBG_PIN);
DigitalOut VIOLApin(DBG_PIN_3);
DigitalOut led_pin(STATUS_LED_PIN);
/* 
    DEFINIZIONE CODA DATI 
*/
MemoryPool<record_t, RECORD_NUMBER*RECORD_SIZE> mpool;
Queue<record_t, RECORD_NUMBER*RECORD_SIZE> queue;
/*
    SCRITTURA SU SD CARD
*/
void writeOnSDcard(void)
{
    while(1)
    {
        Thread::wait(10);
        osEvent evt = queue.get();
        if((evt.status == osEventMessage) && (start_writing == true))
        {
            record_t *message = (record_t*)evt.value.p;
            BLUpin = 1;                
            fprintf(fp, "%06d;%04x;%08d;%05x;%05x;%05x;%03x;%06x;%06x;%06x;%06x;%06x;%06x \r\n",
                        message->index,              //#
                        message->error,              //Error
                        message->timestamp,          //Timestamp
                        message->adxl355_rawX,       //ACC_DIG_3A_X
                        message->adxl355_rawY,       //ACC_DIG_3A_Y
                        message->adxl355_rawZ,       //ACC_DIG_3A_Z
                        message->adxl355_rawT,       //ACC_DIG_3A_TEMP
                        message->adxl354_rawX,       //ACC_AN_3A_X
                        message->adxl354_rawY,       //ACC_AN_3A_Y
                        message->adxl354_rawZ,       //ACC_AN_3A_Z
                        message->adxl354_rawT,       //ACC_AN_3A_TEMP
                        message->colibrys_rawVal,    //ACC_AN_1A_VAL
                        message->colibrys_rawTEMPval //ACC_AN_1A_TEMP
                        );
            BLUpin = 0;                
            mpool.free(message);
        }else{} 
        
        if((button_int_f == true)&&(start_writing == true))
        {
            fprintf(fp,"DATA END \r\n");
            fclose(fp);         // DO THIS AT THE END!!!
            sd.deinit();
            fs.unmount();
            start_writing = false;
            
            Thread::wait(100);
            if(adxl355_start_acquisition(adxl355_none) == 0)
            {
                led_pin = 0; 
                YELLOWpin = 1;    
            }else{}
                                          
        }else{}  
    }        
}  
/*
    THREAD SCRITTURA SU SD CARD
*/
Thread writeSDthread(writeOnSDcard); 
/* 
    NUOVI DATI ADXL355 
*/ 
void adxl355_newData(void) 
{      
    while (true) 
    {   // Signal flags that are reported as event are automatically cleared.
        Thread::signal_wait(ADXL355_SIGNAL);
        GREENpin = 1;       
        if(adxl355_get_data(&adxl355_config) != 0)
        {
            adxl355_newData_error |= 0xFF00; 
        }else{}
                   
        file_index++; 
        adxl355_newData_timestamp = HAL_GetTick();
        adxl355_newData_error |= (uint16_t)(adxl355_newData_timestamp - adxl355_int_timestamp);         
                                                       
        record_t *message = mpool.alloc();
        message->index = file_index;
        message->error = adxl355_newData_error;
        message->timestamp = adxl355_newData_timestamp;
            
        message->adxl355_rawX = adxl355_raw_x_acc(&adxl355_config);
        message->adxl355_rawY = adxl355_raw_y_acc(&adxl355_config);
        message->adxl355_rawZ = adxl355_raw_z_acc(&adxl355_config);       
        message->adxl355_rawT = adxl355_raw_temp(&adxl355_config);
            
        message->adxl354_rawX = 3;
        message->adxl354_rawY = 3;
        message->adxl354_rawZ = 3;            
        message->adxl354_rawT = 3;   
            
        message->colibrys_rawVal = 4;
        message->colibrys_rawTEMPval = 4;
        
        queue.put(message);  
        
        adxl355_newData_error = 0;
             
        GREENpin = 0; 
    }
} 
/* 
    THREAD NUOVI DATI ADXL355 
*/
Thread adxl355Thread(adxl355_newData);
/* 
    FUNZIONE DI GESTIONE DELL'INTERRUPT ADXL355 
*/
void adxl355_int_handler(void) 
{
    VIOLApin = 1;
    adxl355_int_index++;
    if(adxl355_int_index == 5)
    {
        adxl355_int_timestamp = HAL_GetTick();
        adxl355_int_index = 0;
        adxl355Thread.signal_set(ADXL355_SIGNAL);  
    }else{};
//    adxl355Thread.signal_set(ADXL355_SIGNAL);        
    VIOLApin = 0;
} 
/* 
    FUNZIONE DI GESTIONE INTERRUPT PULSANTE 
*/
void pressed(void)
{       
    button_int_f = true;
}




int main() 
{
    uint16_t u16error;
    
    start_writing = false;
    button_int_f = false;
    file_index = 0;    
    adxl355_int_timestamp = 0;    
    adxl355_int_index = 0;    
        
    led_pin = 0;    
        
    BLUpin = 0;
    GREENpin = 0;
    VIOLApin = 0;
    
    /* Impulso che segnala l'avvio del codice */
    YELLOWpin = 0;
    YELLOWpin = 1;
    YELLOWpin = 0;

    /* Setting SPI */    
    spiHandler.frequency(SPI_FREQUENCY_HZ);
    spiHandler.format(8, 0);//POL = 0; PHA = 0  
        
    /* Setting interrupt su pin accelerometro */
    adxl355_int.rise(&adxl355_int_handler);  
    /* Setting interrupt pulsante */
    user_button.fall(&pressed);
     
    /* Init ADXL355 */
    u16error  = adxl355_init(&adxl355_config);    
    if(u16error != 0)
    {
        //VIOLApin = !VIOLApin; 
    }else{}   
    /* Init SD CARD reader */        
    sd.init();
    fs.mount(&sd);
    fp = fopen("/fs/mydata.csv", "w");    
    if(fp == NULL) 
    {
        start_writing = false;
        led_pin = 0;
    }
    else
    {   
        start_writing = true;        
        fprintf(fp,"#;ERROR;TIMESTAMP;ACC_DIG_3A_X;ACC_DIG_3A_Y;ACC_DIG_3A_Z;ACC_DIG_3A_TEMP;ACC_AN_3A_X;ACC_AN_3A_Y;ACC_AN_3A_Z;ACC_AN_3A_TEMP;ACC_AN_1A_VAL;ACC_AN_1A_TEMP\r\n");        
        u16error = adxl355_start_acquisition(adxl355_both);
        if(u16error != 0)
        {
            led_pin = 0;
            fclose(fp);
            sd.deinit();
            fs.unmount();
            start_writing = false;
        }else
        {
            led_pin = 1;  
        }
    }    
    
    while(1)
    {
        Thread::wait(1000);        
    }
 
}
