#include "mbed.h"
#include "Dht11.h"
#include "MODSERIAL.h"
MODSERIAL usbser(USBTX, USBRX); // tx, rx
MODSERIAL devser(PTE22, PTE23); // tx, rx
//Serial usbser(USBTX, USBRX); // tx, rx
//Serial devser(PTE22, PTE23); // tx, rx
DigitalOut R(LED1);
DigitalOut G(LED2);
DigitalOut B(LED3);

Dht11 mydht11(D9);

int main(void) 
{
    char X;
    float t,h;

    usbser.baud(9600);
    devser.baud(9600);
    R=1;
    G=1;
    B=1;
    
    while (true) 
     {
        mydht11.read(); // Read DHT11 sensor
        t = mydht11.getCelsius(); // get Temperature in C
        h = mydht11.getHumidity(); // get Humidity in %
        printf("Temperature is : %0.2f C\r\n",t);
        wait(0.5);
        
        if(usbser.readable())
        {
            devser.putc(usbser.getc());
        }
        
        if(devser.readable())
        {
            X=devser.getc();
            usbser.putc(X);
            printf("\r\n");
            if(X == 'R')
            {
                G=1;
                B=1;
                R=0;            
            }
            else if(X == 'G')
            {
                R=1;
                B=1;
                G=0;
            }
            else if(X == 'B')
            {
                R=1;
                G=1;
                B=0;
            }
            else
            {
                R=0;
                G=0;
                B=0;
            }
        }
     }
}
