//Include

#include "mbed.h"
#include "PwmIn.h"
#include "Nucleo_Encoder_16_bits.h"

//Defines

#define BOUSSOLE_adress     0xC0
#define PIXY_adress         0x54

#define CC_BLOCSIZE         14
#define N_BLOCSIZE          12

#define N_BLOCCODE          0xAA55
#define CC_BLOCCODE         0xAA56

#define SPI_READ_NOP        0x0003
#define SPI_READ_ANGLE      0xFFFF
#define SPI_READ_ERROR      0x8002
#define SPI_READ_SETTINGS1  0x1803
#define SPI_READ_SETTINGS2  0x8902
#define SPI_WRTIE_SETTINGS1 0x1800
#define SPI_WRITE_SETTINGS2 0x9801

//Defines automate

#define START 0
#define SEEK_BALL 1
#define TURN_TO_BALL 2
#define GO_TO_BALL 3
#define CAPTURE_AND_TURN 4
#define WALL_CAPTURE_AND_TURN 5
#define RELEASE_CAPTURE 6
#define BALL_LAUNCHING 7
#define STOP_BALL_LAUNCHING 8
#define TURN_TO_BASE 9
#define RETURN 10
#define WALL_RETURN 11
#define STOP_RETURN 12
#define SEEK_ROTATION 13

//Typedef

typedef unsigned char   Byte;
typedef unsigned short  Word;
typedef unsigned long   lWord;

typedef enum {S_monte = 1, S_descente = 0} T_SERVODIR;

typedef enum {none, begin, normal, colorCode, doubleZero} T_pixyState;

typedef union {
    lWord   mot;
    Byte    tab[4];
} T_tmpBuffer;

typedef union {
    Word    mot;
    Byte    tab[2];
} T_structBuffer;

typedef struct {
    Word    checksum;
    Word    signature;
    Word    x;
    Word    y;
    Word    width;
    Word    height;
    Word    angle;
} T_pixyCCBloc;

typedef struct {
    Word    checksum;
    Word    signature;
    Word    x;
    Word    y;
    Word    width;
    Word    height;
} T_pixyNMBloc;

typedef union {
    Byte            tab[14];
    T_pixyCCBloc    CCbloc;
} T_pixyCCData;

typedef union {
    Byte            tab[12];
    T_pixyNMBloc    NMbloc;
} T_pixyNMData;