#include "mbed.h"
#define DEV_ADDR    0xAE

I2C     i2c(PB_11, PB_10);
Serial     pc(PA_2, PA_3);
AnalogIn        FWD(PA_0);
AnalogIn        REF(PA_1);

void AT24C32_WriteBytes(uint16_t addr, uint8_t *pbuf, uint16_t length)
{
    char buf[length+2];
    buf[0] = (uint8_t)(addr>>8);
    buf[1] = (uint8_t)(addr);
    memcpy(&buf[2], pbuf, length); 
    i2c.write(DEV_ADDR, buf, length+2, false);
}

void AT24C32_ReadBytes(uint16_t addr, uint8_t *pbuf, uint16_t length)
{
    char buf[2];
    buf[0] = (uint8_t)(addr>>8);
    buf[1] = (uint8_t)(addr);
    i2c.write(DEV_ADDR, buf, 2, false);
    
    i2c.read(DEV_ADDR, (char *)pbuf, length, false);
}

float measure_REF;

uint8_t w_buf[1];
uint8_t r_buf[1];
uint8_t byte =0;
int addr=0x00;
char Data=0;
int main(void)
{
    uint8_t index=0;
 
  
    pc.baud(9600);
    pc.printf("IIC Demo Start \r\n");
    
    while(1)
    {
//WRITE**************************************
        
        uint8_t byte = REF.read_u16() >> 8;
        pc.printf("EEPROM Write Byte= %d\n",byte);
        AT24C32_WriteBytes(addr,&byte,1);
//*******************************************

//READ***************************************      
        wait(1);
        AT24C32_ReadBytes(addr, r_buf,1);
        for(index=0; index<1; index++)
        Data=(r_buf[index]);
        pc.printf("EEPROM Read Byte=%d\n",Data);
        
    }
}