/***********************************************************************************************
Program:        Bitmasking Test Prep
Author:         B. Smith, C. Talbot
Date:           April 6th, 2015
(c) 2015 Fanshawe College

Modified:    _______________   

Description: Program demonstrates PwmOut, printf, reading a BCD iput using the 
            FRMD-KL25Z Platform. This program reads a BCD switch and switches 
            the LED between 3 states: On, OFF or Flashing 
            and controls an up/down counter.
            
            The 3 states are created by adjusting the duty cycle of the PWM signal.
            The LED flashing is seen by the human eye because of the relatively long
            (50ms) period of the waveform. 
***********************************************************************************************/



#include "mbed.h"


#define RGBLEDON  0
#define RGBLEDOFF 1

#define LEDON  1
#define LEDOFF 0

#define GREENLED  PTD4
#define YELLOWLED PTA12
#define REDLED    PTA4

#define PB_PRESSED  0
#define PB_RELEASED 1


//TODO: set the datatype to allow the generation of a pulse width modulating signal
________ myFlashingLED(REDLED);

//TODO: set the datatype to read all 4 bits at the same time
________ BCDSwitch(PTD0, PTD1, PTD2, PTD3);    // BCD rotary dial  Active Low




Serial pc(USBTX, USBRX);


//TODO!!! student: insert function comment header here

void initializeSystem()
{
    myFlashingLED.period_ms(50);
    
    //TODO: initialize dutycycle to 0
    ________________________
    
}


int main()
{
    //TODO: call function to initialize system
    ________________________
    

    int counter = 0;
   //TODO: print message to user "Starting program"
    ________________________

    while (true) {
        wait(0.5f); // wait a small period of time
        
        //TODO: read the BCD switch 
        //the switches inside are active low so position 9 reads 0110, 8 reads 0111, ... 0 reads 1111
        char state = ____________________
        
        // TODO: invert each bit of the state variable so position 9 reads as 1001 instead of 0110
       
       
        //Unfortunately this causes the upper nibble to invert too
        // 0000 0110 inverted to become 1111 1001, we don't want the upper nibble
        
        // TODO:  MASK OFF the upper nibble by forcing the upper bits to 0 using bitwise AND
        _____________________________
        
        
        //Finally state will contain a value in the range of 0 to 9 ( 0000 to 1001 )
        // but we want a value of 0 to 2 to correlate to the 3 states of the LED
        
        //TODO: perform a modulus division by 3 on the variable state
        // to provide the remainder of the integer division
        // The result a range of values [ 0, 1, or 2 ]
        ________________________________
        
        
        // TODO: print the contents of the variable state
        // The variable named state will now have the value of 0 , 1 or 2 stored inside it
        ________________("State: ___________",______________);
        
        
        //TODO: pause 300 milliseconds
        __________________
        
        switch(state){
            case 0:
                //TODO: print a message to user "Counter is reset and paused"
                _________________________
                
                //TODO: set the duty cycle of the LED to turn is OFF
                _______________
                
                
                //TODO: reset the counter to zero
                _________________
                break;
            case 1:
                //TODO: print a message to user "Counter is counting down from 7 to 0"
                _________________________
                
                //TODO: set the duty cycle of the LED to turn is flashing
                _______________
                
                
                //TODO: decrement the counter
                _________________
                
                 //TODO: mask the counter to keep the counter within the range of 7 to 0
                _________________
                break;
            case 2:
                //TODO: print a message to user "Counter is counting up from 0 to 15"
                _________________________
                
                //TODO: set the duty cycle of the LED to turn is ON steady
                _______________
                
                
                //TODO: increment the counter
                _________________
                
                 //TODO: mask the counter to keep the counter within the range of 0 to 15
                _________________
                break;      
            }//eo switch
        
        // TODO: print the value of variable counter
        _______________("counter: ______ \n\r", __________); 
        
    }
}










