#include "mbed.h"

DigitalOut myled(LED_GREEN);
Serial pc(USBTX, USBRX);


//
//  main.c
//  array example get min max
//
//  Created by BradDSmith on 2013-02-06.
//  Copyright (c) 2013 BradDSmith. All rights reserved.
//

#include <stdio.h>
#include <stdlib.h>  //required for rand functions
#include <time.h>    //required for time function

typedef int pressure_t;

#define MAXSAMPLES 60


pressure_t vesselPressure[MAXSAMPLES];

void initializePressureSamplingArray()
{
    srand((int)time(NULL));
    for (int i = 0 ; i < MAXSAMPLES; i++)
        {
        vesselPressure[i] = rand()%30 + 70;//MAXSAMPLES - i
        }
}

pressure_t getMaxPressure()
{
    pressure_t maxPressure = vesselPressure[0];
    
    for (int i = 1; i < MAXSAMPLES; i++)
        {
        if (maxPressure<vesselPressure[i])
            {
            maxPressure= vesselPressure[i];
            }
        }
    return maxPressure;
}

pressure_t getMinPressure()
{
    pressure_t minPressure = vesselPressure[0];
    
    for (int i = 1; i < MAXSAMPLES; i++) {
        if (minPressure>vesselPressure[i]) {
            minPressure= vesselPressure[i];
        }
    }
    
    return minPressure;
}


pressure_t calculateAveragePressure()
{
    pressure_t averagePressure = 0 ;
    pressure_t sum = 0;
    
    for( int i = 0 ; i < MAXSAMPLES; i++)
        {
        sum += vesselPressure[i];
        }
    
    averagePressure = sum / MAXSAMPLES;
    return averagePressure;
}

void printPressureHistogram()
{
    //create the distribution array and initialize to zero
    int freqDistribution[10];
    for(int i = 0; i < 10; i++)
        {
        freqDistribution[i] = 0;
        }

    //examine each recorded pressure and determine which band to increment
    for (int i =0; i < MAXSAMPLES; i++)
        {
        int band = vesselPressure[i]/10;
        
        freqDistribution[ band ] += 1;
        }
    
    //print the chart
    pc.printf("\n\rTemperature \tHistogram");
    pc.printf("\n\r  Range                ");
    pc.printf("\n\r-----------------------------------\n\r");
    for (int i = 0; i < 10; i++)
        {
        pc.printf("%2d to %2d\t\t", i*10, i*10+9);
        // \t = tab , aligns the start of X's
        // notice the alignment of values due to the %2d
        
        //for a band of X's proportion in length to freq distribution
        for (int xCounter = 0 ; xCounter < freqDistribution[i]; xCounter++)
            {
            pc.printf("X");
            }
        pc.printf("\n\r");
        }
    
}

void reverseArray()
{
    pc.printf("\n\rOriginal Array\n\r");
    for (int i = 0; i < MAXSAMPLES; i++)
        {
        pc.printf("%d ", vesselPressure[i]  );
        }
    
    int leftIndexer = 0;
    int rightIndexer = MAXSAMPLES - 1;
    
    while (leftIndexer < rightIndexer)
        {
        pressure_t swap = vesselPressure[leftIndexer];
        
        vesselPressure[leftIndexer] = vesselPressure[rightIndexer];
        
        vesselPressure[rightIndexer] = swap;
        
        leftIndexer++;
        rightIndexer--;
        }
    
    pc.printf("\n\rReversed Array\n\r");
    for (int i = 0; i < MAXSAMPLES; i++)
        {
        pc.printf("%d ", vesselPressure[i]  );
        }
    
}

void sortArray()
{
    for (int runsLeft = MAXSAMPLES-1; runsLeft > 0; runsLeft--) {
        for (int i = 0; i < runsLeft; i++) {
            if(vesselPressure[i]> vesselPressure[i+1] )
                {
                pressure_t swap = vesselPressure[i];
                vesselPressure[i] = vesselPressure[i+1];
                vesselPressure[i+1] = swap;
                }
            }
        }
    
}

int main()
{

    // insert code here...
    pc.printf("Pressures!\n\r\n\r");
    
    initializePressureSamplingArray();
    
    pressure_t max = getMaxPressure();
    pressure_t min = getMinPressure();
    
    pc.printf("Maximum pressure: %d  Minimum pressure: %d \n\r\n\r", max, min);
    pc.printf("Average Pressure: %d\n\r\n\r", calculateAveragePressure()  );
    printPressureHistogram();
    
    sortArray();
    reverseArray();
    
    pc.printf("\n\r\n\rThat's all folks\n\r");
    return 0;
}

