
#include "mbed.h"

#define RGBLEDON  0
#define RGBLEDOFF 1

#define LEDON  1
#define LEDOFF 0

#define GREENLED  PTA4
#define YELLOWLED PTA12
#define REDLED    PTD4

#define FLASH_STOP_LED   0
#define FLASH_GO_LED     1

#define PB_PRESSED  0
#define PB_RELEASED 1

Serial terminal(USBTX, USBRX);    

DigitalOut myGreenLED(GREENLED, LEDOFF);  //PTD1
DigitalOut myRedLED(REDLED, LEDOFF);    //PTB18

DigitalIn Switch1(PTD5);


int main() {
    myGreenLED = LEDOFF;
    myRedLED = LEDOFF;
    
    bool buttonHasBeenReleased = true;
    int mode = FLASH_STOP_LED;
    int counter = 0;
 
    while(1) 
        {
        
        int switchpos = Switch1.read();
        terminal.printf("Switch: logic level %d\n\r", switchpos);  
        counter++; 
        
        if( switchpos == PB_PRESSED && buttonHasBeenReleased == true)
            {
            if(mode == FLASH_STOP_LED)
                {
                mode = FLASH_GO_LED;
                }
            else
                {
                mode = FLASH_STOP_LED;
                }
            buttonHasBeenReleased = false;  
            }
        else if (switchpos == PB_RELEASED)
            {
             buttonHasBeenReleased = true;
            }
                
            
        if( mode == FLASH_STOP_LED )
            {
            myRedLED = LEDON;
            wait(.2);
            myRedLED = LEDOFF;
            wait(0.2);
            }
        else
            {
            myGreenLED = LEDON;
            wait(.5);
            myGreenLED = LEDOFF;
            wait(0.5);
            }
        }
}
