#include "mbed.h"

DigitalOut myled(LED_GREEN);
Serial pc(USBTX, USBRX);
Ticker sampleTimer;
AnalogIn temperatureSensor(PTB0);


void sampleTemperature();

#define MAXSAMPLES 60
uint16_t temperatures[MAXSAMPLES];
int insertAt;
bool averageIsValid;



// main: ----------------------------------------------------------------------
//
//
//-----------------------------------------------------------------------------
int main()
{
    pc.printf("Hello World!\n\r");
    
    insertAt = 0; 
    averageIsValid = false;
    int i = 0;
    
    // attach the function sampleTemperature() to a timer 
    // that will call it every 1.5 seconds
    sampleTimer.attach(&sampleTemperature, 1.5);   

    while (true)  //so infinite loop ..........................................
        {
        wait(0.5f);               // wait a small period of time
        pc.printf("%d\r\n", i);   // print the value of variable i
        i++;                      // increment the variable
        }//eo infinte loop ::::::::::::::::::::::::::::::::::::::::::::::::::::
        
}//eo main:: ==================================================================


// calculateAverageTemperature: -----------------------------------------------
//
//
//-----------------------------------------------------------------------------
void calculateAverageTemperature()
{
    int average = 0;
    // TODO!!! insert code to calculate average ...............................
    
    
    //eo insert code to calculate average :::::::::::::::::::::::::::::::::::::
    
    pc.printf("Average is %d\n\r", average);
    
}//eo calculateAverageTemperature:: ===========================================

// calculateMinimumTemperature: -----------------------------------------------
// find and print the minimum temperature store within array
//
//-----------------------------------------------------------------------------
void calculateMinimumTemperature()
{
    int minimum = 0;
    // TODO!!! insert code to calculate minimum ...............................
    
    
    //eo insert code to calculate minimum :::::::::::::::::::::::::::::::::::::
    
    pc.printf("Minimum is %d\n\r", minimum);
    
}//eo calculateMinimumTemperature:: ===========================================


// calculateMaximumTemperature: -----------------------------------------------
// find and print the maximum temperature store within array
//
//-----------------------------------------------------------------------------
void calculateMaximumTemperature()
{
    int maximum = 0;
    // TODO!!! insert code to calculate maximum ...............................
    
    
    //eo insert code to calculate maximum :::::::::::::::::::::::::::::::::::::
    
    pc.printf("Maximum is %d\n\r", maximum);
    
}//eo calculateMaximumTemperature:: ===========================================




// sampleTemperature: -----------------------------------------------
//
// This function is called automatically every 5 seconds by
// the sampleTimer. The analog to digital converter samples the 
// voltage and stores its 16bit value into the next available
// location in the array. Once the array is filled (which will take
// 300 seconds) , an average is calculated and sent to the pc
//
//-------------------------------------------------------------------

void sampleTemperature() 
{
    uint16_t current = temperatureSensor.read_u16();
    pc.printf("Current value %d\n\r", current);
    temperatures[insertAt] = current;
    insertAt++;
    if(insertAt >= MAXSAMPLES)
        {
        insertAt = 0;
        averageIsValid = true;
        }
    if(averageIsValid == true)
        {
        calculateAverageTemperature();
        calculateMinimumTemperature(); 
        calculateMaximumTemperature();   
        }
    myled = !myled;
}//eo sampleTemperature:: =====================================================
