/***************************************************************************
Copyright 2016 LARNAUDIE GARIVET
 
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at
 
       http://www.apache.org/licenses/LICENSE-2.0
 
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
***************************************************************************/
#ifndef PeripheralCAN_H
#define PeripheralCAN_H

#include "mbed.h"
#include <vector>
#include "ControllerCAN.h"

class ControllerCAN;
/** My CAN Peripheral class
 * Used as interface to create CAN Peripheral objets
 *
 * Examples :
 * @code
 * @endcode
 */
class PeripheralCAN {
    public :
    /** Create PeripheralCAN instance
     */
    PeripheralCAN();
    
    /** Create PeripheralCAN instance
     *
     * @param controller ControllerCAN instance controlling the PerpiherialCAN
     */
    PeripheralCAN(ControllerCAN* controller);
    
    /** Initialize the instance 
     */
    virtual void init(void);
    
    /** Update the PeripheriamCAN instance
     *
     * @param Id Message Id to determine which variables are concerned,
     * @param msg CANMessage instance containing data of interest
     */
    virtual void update(const unsigned short& Id, const CANMessage& msg);
    
    /** Add an Id to the Id vector containing Ids of incoming message
     * concerning the current instance
     *
     * @param Id Message Id to be added
     */
    void addIdRead(unsigned short* Id);
    
    /** Write a message on CAN Bus
     *
     * @param Id Id message
     * @param data char array containing data to be send
     * @param len size of the data array 
     */
    void writeOnCAN(unsigned short Id, const char *data, char len);
    //short readOnCAN(unsigned short Id, CANMessage& msg);
    
    /** Get the IdsRead vector
     *
     * @returns IdsRead vector
     */    
    vector<unsigned short*> getIdsRead(void);
    
    private :
    vector<unsigned short*> IdsRead;
    ControllerCAN* controllerCAN;
};

#endif
