#include "mbed.h"
#include "mbedWSEsbc.h"
#define PI (3.14159)

// Declaring variables
int go; // variable passed from MATLAB to start data collection
float st = 1.0; // desired sampling time
float sp = 0.01; // sampling period
float dt; // loop time
long O; // oscillations measured
float OR;// oscillations in radians
float low;
float high;
float ang_pos_prev = 0.0;
float omega;
float dc;
float Time; // reset time variable

int main()
{
    mbedWSEsbcInit(115200); // initialize ES305 breakout board
    mot_en1.period(0.020);
    
    // User initializes data collection w/o MATLAB
    pc.printf("Press 1 to start data collection"); // prompts user
    // pc.scanf("%.0f",&go); // records user input

    // MATLAB initialized data collection
    pc.scanf("%d,%f,%f",&go,&low,&high);

    while(go == 1) {

        Time = 0.0;
        t.reset(); // reset timer object

        while(Time <= st) {
            t.start(); // starting timer for sample

            // data collection and processing
            O = LS7366_read_counter(1); // reads from encoder
            OR = O*(2*PI/6500.0); // counts to radians
            omega = (OR-ang_pos_prev)/sp;
            ang_pos_prev = OR;
            
            if(Time < 0.1){
                dc = 0.0;
            }
            else if(Time >= 0.1 && Time < 0.55){
                dc = low;
            }
            else{
                dc=high;
            }
            
            mot_control(1,dc); // gives the motor a duty cycle
            
            pc.printf("%f,%f,%f\n",Time,omega,dc); // sending values to MATLAB

            
            Time = Time + sp; // updates time

            // wait to achieve sampling rate
            dt = sp - t.read();
            wait(dt);

            t.reset(); // resets timer for sampling loop
        } // ends sampling loop
        mot_control(1,0.0);
        // repeat data collection if need exists
        // pc.printf("Run data collection again? Press 1. If not, press 0.\n\r");
        pc.scanf("%d,%f,%f",&go,&low,&high);

    } // ends data collection trigger loop

} // ends main
