//Daniel Camuti and Hannah Hjelmstrom
//ES301 - Coupled Tank System Part 2

#include "mbed.h"
// APIs
Serial pc(USBTX, USBRX); // tx, rx for serial USB interface to pc
SPI spi_max1270(p5, p6, p7);
SPI spi(p5, p6, p7);
DigitalOut max1270_cs(p8);  //MAX1270 ADC CS
DigitalOut mot1_ph1(p21);
//DigitalOut mot1_ph2(p22);
PwmOut mot_en1(p23);

LocalFileSystem local("local"); // Create the local filesystem under the name "local"

int read_max1270(int chan, int range, int bipol)
{
    int cword=0x80;     //set the start bit

    spi_max1270.frequency(10000000);
    spi_max1270.format(8, 0);   // 8 data bits, CPOL0, and CPHA0 (datasheet Digital Interface)

    cword |= (chan << 4);   //shift channel
    cword |= (range << 3);
    cword |= (bipol << 2);

    max1270_cs = 0;

    spi_max1270.write(cword);
    wait_us(15);    //15us
    spi_max1270.format(12, 3);

    int result = spi_max1270.write(0);

    max1270_cs = 1;
    spi_max1270.format(8, 0);
    return result;
}

float read_max1270_volts(int chan, int range, int bipol)
{
    float rangevolts=0.0;
    float volts=0.0;
    int adc_res;

    //read the ADC converter
    adc_res = read_max1270(chan, range, bipol) & 0xFFF;

    //Determine the voltage range
    if(range)  //RNG bit
        rangevolts=10.0;
    else
        rangevolts=5.0;

    //bi-polar input range
    if(bipol) { //BIP is set, input is +/-
        if(adc_res < 0x800) { //if result was positive
            volts = ((float)adc_res/0x7FF) * rangevolts;
        } else { //result was negative
            volts = -(-((float)adc_res/0x7FF) * rangevolts) - (rangevolts * 2.0);
        }
    } else { //input is positive polarity only
        volts = ((float)adc_res/0xFFF) * rangevolts;
    }

    return volts;
}

float Tank1,Tank2,dt;
float Ts = 1.0; // Sampling period 1/Ts Hz

// Arrays for data storage
float etime[200];
float t1v[200];
float t2v[200];
float dcp[200];
Timer t;


float cntr;
float dc;
int k;

int main ()
{
    pc.baud(921600); // Establish baud rate
    mot_en1.period_us(50); // Set PWM length to 50 us
    max1270_cs = 1; // Activate A/D
    cntr = 0.0; // cntr used to keep track of sample period and elpased time

    // initialize data vectors
    for(k=0; k<100; k++) {
        etime[k] = 0.0;
        t1v[k] = 0.0;
        t2v[k] = 0.0;
        dcp[k] = 0.0;
    }
    k = 0; // Reset index counter
    pc.printf("Time Tank1 Tank2 DC \n\r");
    while(cntr*Ts <= 200) {
        t.start(); // start measuring comp time

        // Read pressure sensors
        Tank1 = read_max1270_volts(1, 1, 1); // in volt
        Tank2 = read_max1270_volts(0, 1, 1);

        // Select pump duty cycle, start time, and end time
        if (cntr*Ts <= 20) { //start time
            dc = 0.0;
        } else if (cntr*Ts <= 200) { //end time
            //
            //dc = -0.80; // duty cycle (must be negative)
            //dc=-0.60;
            //dc=-0.65;
            dc=-0.70;
            //dc=-0.75;
            //dc = -0.0;
        } else {
            dc = 0.0;
        }

        if(dc > 0.0) {
            //mot1_ph2 = 0;
            mot1_ph1 = 1;
            mot_en1 = dc;
        } else if(dc <=0.0) {
            mot1_ph1 = 0;
            //mot1_ph2 = 1;
            mot_en1 = abs(dc);
        }

        // Log data
        etime[k] = cntr*Ts;
        t1v[k] = Tank1;
        t2v[k] = Tank2;
        dcp[k] = -dc;
        k++;

        t.stop(); // end measuring comp time
        dt = Ts-t.read();
        //pc.printf("%5.2f %5.2f %5.2f %5.2f \n\r",cntr*Ts,Tank1,Tank2,dc);
        pc.printf("%5.2f %5.2f %5.2f %5.2f \n\r",cntr*Ts,Tank1,Tank2,dc);
        t.reset();
        cntr=cntr+1;
        wait(dt); // wait to ensure sampling period set by Ts
    }//while
    //mot1_ph2 = 0;
    mot_en1 = 0.0;


}//main
