#include "mbed.h"
#include "Servo.h"
#include "MODSERIAL.h"

MODSERIAL pc(USBTX, USBRX);
InterruptIn mbut(PTA4);
InterruptIn sbut(PTC6);
DigitalOut mode_signal(D2);
DigitalOut led_rood(LED_RED);
DigitalOut led_groen(LED_GREEN);
DigitalOut led_blauw(LED_BLUE);

int mode = 1;

void mode_switcher() {
           
    switch(mode){
        case 1: mode_signal = 1;
                mode_signal = 0;
                led_rood = 0;
                led_groen = 1;
                led_blauw = 1;
                break;
        case 2: mode_signal = 1;
                mode_signal = 0;
                led_rood = 1;
                led_groen = 0;
                led_blauw = 1;
                break;
        case 3: mode_signal = 1;
                mode_signal = 0;
                led_rood = 1;
                led_groen = 1;
                led_blauw = 0;
                break;
        case 4: mode_signal = 1;
                mode_signal = 0;
                led_rood = 0;
                led_groen = 0;
                led_blauw = 0;
                break;
        case 5: mode_signal = 1;
                mode_signal = 0;
                led_rood = 1;
                led_groen = 0;
                led_blauw = 0;
                break;
        case 6: mode_signal = 1;
                mode_signal = 0;
                led_rood = 0;
                led_groen = 0;
                led_blauw = 1;
                break;
        }
    
    pc.printf("The system is in mode %i\r\n", mode);
    
    mode += 1;
    
    if (mode==7) {
        mode = 1;
    }
    
}


//------------------------------------------------------------------------------
//--------------------------------Servo-----------------------------------------
//------------------------------------------------------------------------------
Servo MyServo(D9);
InterruptIn But1(D8);
int k=0;

void servo_control (){
    if (k==0){
        MyServo = 0;
        k=1;
    }
    else{
        MyServo = 2;
        k=0;
        }
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
    


int main()
{
    led_rood = 1;
    led_groen = 1;
    led_blauw = 1;
    
    pc.baud(115200);
    mbut.rise(&mode_switcher);
    sbut.rise(&servo_control);
}