#include "mbed.h"
 
DigitalOut motor1DirectionPin(D4);
PwmOut motor1MagnitudePin(D5);
DigitalIn button1(D8);
AnalogIn potMeterIn(A3);
Ticker tick;
 
 
 
float GetReferenceVelocity()
{
    // Returns reference velocity in rad/s. 
    // Positive value means clockwise rotation.
    const float maxVelocity=8.4; // in rad/s of course!  
     
    float referenceVelocity;  // in rad/s
        if (button1)
        {       //Clockwise rotation
            referenceVelocity = potMeterIn * maxVelocity;  
        } 
        else
        {
        // Counterclockwise rotation       
            referenceVelocity = -1*potMeterIn * maxVelocity;   
        }
        return referenceVelocity;
}
 
void Setmotor1(float motorValue)
{
    // Given -1<=motorValue<=1, this sets the PWM and direction
    // bits for motor 1. Positive value makes motor rotating
    // clockwise. motorValues outside range are truncated to
    // within range
    if (motorValue >=0) {
        motor1DirectionPin=1;
        }
    else {
        motor1DirectionPin=0;
        }
    if (fabs(motorValue)>1) {
        motor1MagnitudePin = 1;
        }
    else {
        motor1MagnitudePin = fabs(motorValue);
        }
 
}
 
float FeedForwardControl(float referenceVelocity)
{
    // very simple linear feed-forward control
    const float MotorGain=8.4; // unit: (rad/s) / PWM
    float motorValue = referenceVelocity / MotorGain;
    return motorValue;
}
void MeasureAndControl(void)
{
    // This function measures the potmeter position, extracts a
    // reference velocity from it, and controls the motor with 
    // a simple FeedForward controller. Call this from a Ticker.
    float referenceVelocity = GetReferenceVelocity();
    float motorValue = FeedForwardControl(referenceVelocity);
    Setmotor1(motorValue);
}
 
int main()
{
       
    tick.attach(MeasureAndControl, 0.5f);
    
  
 
}