#include "mbed.h"
#include "HIDScope.h"                      //require the HIDScope library
#include "MODSERIAL.h"
#include "BiQuad.h"

//                       DEFINING                  
//Define Inputs
AnalogIn emg(A0);                               //analog of EMG input
InterruptIn button1(PTA4);                        //test button for starting motor 1
InterruptIn button2(SW2);                         //FOR DEBUGGING

//Define Outputs
DigitalOut led1(LED_RED);
DigitalOut led2(LED_BLUE);
DigitalOut led3(LED_GREEN);                     //FOR DEBUGGING
MODSERIAL pc(USBTX,USBRX);


//Define Tickers
Ticker      sample_timer;                       // Taking samples
Ticker      LED_timer;                          // Write the LED
Ticker      calibration_timer;                  // Check when to start calibration
//MODSERIAL pc(USBTX,USBRX);

//Define HIDscope
HIDScope    scope(2);                           //instantize a 2-channel HIDScope object


//Define filters and define the floats which contains the values.
BiQuadChain bqc;
BiQuad bq1_low(1.34871e-3, 2.69742e-3, 1.34871e-3, -1.89346, 0.89885);
BiQuad bq2_high(0.96508, -1.93016, 0.96508, -1.92894, 0.93138);
BiQuad bq3_notch(0.91859, -1.82269, 0.91859, -1.82269, 0.83718);

double emgFiltered;
double filteredAbs;
double emg_value;
double onoffsignal;
double maxcal=0;        
bool aboveTreshold=0;

//                      FUNCTIONS                
//function for filtering

void filter(){                                      
    if(aboveTreshold==1){
        
        emg_value = emg.read();
        emgFiltered = bqc.step( emg_value );
        filteredAbs = abs( emgFiltered );
    
        onoffsignal=filteredAbs/maxcal;             //divide the emg signal by the max EMG to calibrate the signal per person
        scope.set(0,emg_value);                     //set emg signal to scope in channel 1
        scope.set(1,onoffsignal);                   //set filtered signal to scope in channel 2
        scope.send();                               //send the signals to the scope
//            pc.printf("emg signal %f, filtered signal %f \n",emg_value,onoffsignal);
    }
}

//function to check the threshold
void checkthreshold(){                                  
    if(aboveTreshold==1){                                      //if signal passes threshold value, red light goes on
            if(onoffsignal<=0.25){
                    led1.write(1);
                    led2.write(0);
            }
            else if(onoffsignal >= 0.5){                //if signal does not pass threshold value, blue light goes on
                    led1.write(0);
                    led2.write(1);
            }
    }
}

//function to calibrate
void calibration(){                                            
    if(button1.read()==false){
        led3.write(0);
        for(int n =0; n<5000;n++){                          //read for 5000 samples as calibration
            led3.write(0);
            emg_value = emg.read();
            emgFiltered = bqc.step( emg_value );
            filteredAbs = abs( emgFiltered );
           
            double signalmeasure = filteredAbs;
            if (signalmeasure > maxcal){                    //determine what the highest reachable emg signal is
                maxcal = signalmeasure;
            }
        }
        aboveTreshold=1;
        led3.write(1);
    }  
}
 
//                         MAIN                      
 
int main(){
//    pc.baud(115200);

//    pc.printf("Lampjes zijn langs geweest");
    led1.write(1);
    led2.write(1);
    led3.write(1);
    
    bqc.add( &bq1_low ).add( &bq2_high ).add( &bq3_notch );

    sample_timer.attach(&filter, 0.002);                //continously execute the EMG reader and filter
    LED_timer.attach(&checkthreshold, 0.002);         //continously execute the motor controller
    calibration_timer.attach(&calibration, 0.002);              //ticker to check if EMG is being calibrated
//    pc.printf("%d",filteredAbs);
    
    
    
    while(1){     //while loop to keep system going 
                                                        
    }     
}