#include "stepmotor.h"
#include "mbed.h"
 

stepmotor::stepmotor(PinName in1, PinName in2, PinName in3, PinName in4) : motor_out(in1,in2,in3,in4) { 

    motor_out=0x0;
    nstep=0;
    motorSpeed=1100;
    
}
 
void stepmotor::move() { 
   
   switch(nstep)
        { 
            case 0: motor_out = 0x1; break;  // 0001
            case 1: motor_out = 0x3; break;  // 0011
            case 2: motor_out = 0x2; break;  // 0010   
            case 3: motor_out = 0x6; break;  // 0110
            case 4: motor_out = 0x4; break;  // 0100
            case 5: motor_out = 0xC; break;  // 1100
            case 6: motor_out = 0x8; break;  // 1000
            case 7: motor_out = 0x9; break;  // 1001
            
            default: motor_out = 0x0; break; // 0000
        }
        wait_us(motorSpeed);
        
}

void stepmotor::set_speed(int speed){
    motorSpeed=speed; //set motor speed us 
}
uint32_t stepmotor::get_speed(){
    return motorSpeed; // 
}

void stepmotor::step(uint32_t num_steps, bool cw) {
// funcion para mover el motor N pasos CW o CCW   
// num_steps  número de paso que da el motor 
// cw =True  para dirección en sentido del reloj 
// cw =False para dirección contraria de las manecillas del reloj         
   
    uint32_t count=num_steps ;
    while(count){
        if (cw)   nstep++;     
        else      nstep--;
        if (nstep>7) nstep=0;
        if (nstep<0) nstep=7;
        move();
        count--;
    }
}