#include "mbed.h"
#include "memory.h"

int mem_head = 0;  //cabeza de memoria
int mem_tail = 0;  //cabeza de cola
uint8_t full = 0;

MEM_TYPE buffer[MEM_SIZE]; // reserve memoria tamaño 10

void tail_reset()  // reinicio el valor de la cola en 0
{
 mem_tail=0;
}

void mem_free()  // reinicio el valor de la cabeza y full a 0
{
 mem_head=0;
 full=0;
}

uint8_t mem_put(MEM_TYPE data) // poner dato en memoria "Escribir dato"
{
     if (full)
        return 1;
    buffer[mem_head] = data; // envio dato a grabar 
    mem_head += 1;           // aumente la cabeza en 1
    if (mem_head == MEM_SIZE)  // envio error memoria llena si cabeza es igual a 10(tamaño total de la memoria)
        full =1;
    return 0;
}

uint8_t mem_get(MEM_TYPE* data) // leer dato en memoria
{
    if (mem_head == 0) // envio error no hay nada en memoria
        return 1; 
    if (mem_head == mem_tail) // envio error memoria llena
        return 1; 
    
    *data = buffer[mem_tail];  // apuntador selecciona memoria a leer
    mem_tail += 1;            //
  
    return 0;
}