#include "mbed.h"
#include "main.h"

void Rx_interrupt();
void Rx_interruptBT();
void trasladar (uint8_t ,uint8_t);
void cuadrante ();
void cuadro(uint8_t);
void pause();

/*
El sitema tiene tres estados:
1. Standby: estado que indica que esta en espera de un telecomando (Ejecutar 0 guardar)
2. Drawing: estado en donde el piccolo eejecuta las ordenes giardadas en el array 
            de memora hasta encontrar el comando CM_STOP 
3. Saving:  estado donde el sistema recibe lso datos y lso almacena en memoria acorde 
            a los comandos de 0xfd, oxfc, 0xfb,0cfa, se sake de este modo cuado se recibe
            el comando CM_STOP
            
todo telecomando debe finalizar con el dato CM_END
*/

stepmotor smotor1(D7,D9,D11,D12);

Serial command(USBTX, USBRX);
Serial deviceBT(D8, D2); //D8=TX  D2=RX

uint8_t estado;
uint8_t control=CM_PLAY;

int main() {
    init_servo();
    init_serial();
    draw();
    nodraw();
    home();
    debug_m("Inicio programa piccolo \n");
    uint32_t read_cc;
         
    while(1)
    {          
        read_cc = read_command();
        switch (read_cc) {
            
            case  CM_EXECUTING: estado=1;
                                command.attach(&Rx_interrupt, Serial::RxIrq);
                                deviceBT.attach(&Rx_interruptBT, Serial::RxIrq);
                                drawing();
                                command.attach(NULL, Serial::RxIrq);
                                deviceBT.attach(NULL, Serial::RxIrq);
                                break;
            
            case  CM_SAVING:    estado=2;
                                saving(); 
                                break;

            default:  
                 debug_m("Error de comando. \nSe espera  0xFEF0 o 0xFFF0 \n");      
                 break;
    } 
}    
}

uint32_t read_command()  // concatenar
{
   /* retorna los byte recibidos concatenados en un entero, se reciben maximo 4 bytes,
    recibe hasta que encuetra  un fin de comando "CM_END".
    Ejemplo: para el comando drawing se 
    espera un byte,  por lo que al recibir 0xFF y 0xF0 la funcióm  retorna el 0xff
    siempre y cuando se reciba el fin de dato  F0 de lo contrario retorna un cero
    para el caso del comando vertex2d se espera  recibir 3 bytes, 1 del comando 
    y dos bytes para x y y, se retorna la concatenación de los tres bytes  siempre y
    cuando el cuarto byte sea CM_END de lo contrario retorna un cero 
    */
    
    int32_t val=0;
    uint8_t cnt=0;
    
    char endc=command.getc();
    
    while(endc != CM_END && cnt <4) {
    if(endc!=CM_END)   
        {
        val=((val<<8) + endc);
        }
     endc=command.getc();
     cnt++;
    }   
    if(endc==CM_END)   
        return val;
    return 0;   //al retornar 0 indica que  no se recibe el comando    
}

void init_serial()
{
    command.baud(9600);
    deviceBT.baud(9600);    
}

void Rx_interrupt() {
         char z=command.getc();
         if(z==CM_PAUSE){
             control = CM_PAUSE; 
            }
         if(z==CM_PLAY){
             control = CM_PLAY;
            }
}

void Rx_interruptBT() {
    char z=command.getc();
      if(z==CM_PAUSE){
          control = CM_PAUSE; 
         }
      if(z==CM_PLAY){
          control = CM_PLAY;
         }
}

void pause(){
    if (control == CM_PAUSE){
          debug_m("Envie PLAY para continuar... \n");
            while(control == CM_PAUSE){wait_ms(200);};
    }
}    

void drawing(){
    /* la funcion se ejecuta siempre y cuando exista datos validos para leer de 
    memoria */ 
    debug_m("Se esta ejecutando el dibujo... \n");       
    uint8_t error=0;
    MEM_TYPE dato;
    tail_reset();  //borra la cabeza de memoria
    
    while(error==0){
        
        error = mem_get(&dato);
        pause();
        if (error==0) {
            switch (dato) {
            case  CM_DRAW:
                    debug_m("-> Baja Z\n");
                    draw();
                    break ;     
            case  CM_NODRAW: 
                    debug_m("-> Sube Z\n");
                    nodraw();
                    break ; 
                     
            default: 
                int y      = (uint8_t)(dato);
                int x      = (uint8_t)(dato>>8);
                char ncomm  = (uint8_t)(dato>>16);
                
                 
                if (ncomm == CM_VERTEX2D) {
                    debug_m("-> Mover piccolo X a %d y Y a %d \n",x,x, y);
                    vertex2d(x,y);
                    }
                
                if (ncomm == CM_MOVER) {
                    debug_m("-> cuadrante %d y sentido %d \n",x,x, y);
                    trasladar (x,y);                
                }  
                
                if (ncomm == CM_QUADRANT) {
                    cuadro (x);                
                }      
                
                break;   
             }
         }        
    }
  debug_m("Fin del comando ..\n");    
}

void cuadro (uint8_t ncuad){

    int x = ncuad;
    int i = 0;
        
        pause();    
        nodraw ();
        pause();
        vertex2d (0,50);
        pause();
        draw ();
        pause();
        vertex2d (50,50); 
        debug_m("Cantidad de cuadrantes a dibujar : %d \n",x,x);   
                
        while (x>i){
              debug_m("Dibujando cuadrante: %d \n",i,i); 
              pause();
              draw();
              pause();
              trasladar (1,1);
              debug_m("-> Mover piccolo X a 0 y Y a 0 \n");
              pause();
              vertex2d (0,0); 
              pause();
              trasladar (1,0); 
              pause();
              nodraw();     
              debug_m("-> Mover piccolo X a 50 y Y a 50 \n");         
              pause();
              vertex2d (50,50);
              pause();
              trasladar (1,1);
              i++;                           
              }
         debug_m("Retornando posicion inicial de dibujo \n"); 
         home ();
         trasladar (1,0);      
 }

void saving(){
    debug_m("Se inicia el comando guardar..\n");    
    
    MEM_TYPE dato=0;
    mem_free();
    while(dato !=CM_STOP){
        dato = read_command();
        if (dato !=CM_STOP)
               mem_put(dato);
    }  
    debug_m("Fin del comando guardar..\n");    
    
}

void trasladar(uint8_t cuadrante, uint8_t sentido){   

        uint32_t speed=1500;
        int i=0;
        
        int a = cuadrante;
        int cw = sentido;
     
        while(a>i)
        {
         smotor1.set_speed(speed);
    
       
         command.printf("velocidad del motor:  %d, %f rpm, CW=%d  \n",smotor1.get_speed(), (60/((smotor1.get_speed()*4.096)/1000)),cw);
        
        int ii;
        for(ii=0;ii<64;ii++){
            smotor1.step(64,cw);   
            pause();
                 }
         wait(1);
         i++;  
       }   
}

void debug_m(char *s , ... ){
    #if DEBUG
    command.printf(s);
    #endif  
}
