#include "mbed.h"

/**
 * @file    main.cpp
 * @brief   main file.
 *
 * @addtogroup FirstRun
 * @author  Andreas Rehn
 * @date    20.02.2014
 * @brief   Main module to test led, button und sleepmode together
 * @warning functions run with sleep() and with deepsleep() the system must be start up with InterruptIn
 * @{
 */

Ticker flipper;
InterruptIn button(USER_BUTTON);
DigitalOut led(LED1);

/** function to flip the led  */
void flip(void) {
    led = !led;
}

/** main function
    * initial param for led \n
    * call function flip on rising edge of Button \n
    * attach function flip to Ticker with 2 seconds intervall \n
    * go to sleep or deepsleep (test the difference) \n
    */
int main(void) {
    led = 1;
    button.rise(&flip);
    flipper.attach(&flip, 2.0);
    sleep(); 
    //deepsleep();
    while(1) {
    }
}
/** @} */